/**
 * ParserUtil.java
 * eu.gronos.kostenrechner.util (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.io.File;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.BerechnungXmlDatei;
import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;

/**
 * Die Klasse stellt Methoden bereit, um die Programmparameter zu parsen.
 * 
 * Die Methode {@link #parseDateiname()} prüft, ob eine existierende Datei
 * übergeben wurde. Die Methode {@link #parseDebug()} sucht nach dem Parameter
 * -debug.
 * 
 * @todo TODO UnitTests
 *
 * @author Peter Schuster (setrok)
 * @date 06.09.2018
 *
 */
public class ArgumentParser {

	private final String[] args;

	/**
	 * Konstruktor:
	 * 
	 * @param args der String[] mit den Aufrufparametern aus
	 *             {@link Kostenrechner#main(String[]) main}
	 * 
	 */
	public ArgumentParser(String[] args) {
		super();
		this.args = args;
	}

	/**
	 * Die Methode prüft, ob eine Xjustiz-XML-Datei als Parameter zum Programmaufruf
	 * angegeben wurde oder eine Berechnungs-SKKTX-Datei
	 * 
	 * @return eine Datei als {@link File} oder <code>null</code>, wenn keine
	 *         existierende Datei übergeben wurde
	 */
	public File parseDateiname() {
		for (int i = 0; i < args.length; i++) {
			File datei = null;
			datei = new File(args[i]);
			/* Prüfen nach Endung XML oder SKKTX */
			if (BerechnungXmlDatei.DATEI_FILTER.acceptExtension(datei)
					|| XjustizContentHandler.XJUSTIZ_FILTER.acceptExtension(datei)) {
				if (datei.exists())
					return datei;
			} else {
				datei = new File(args[i] + BerechnungXmlDatei.DATEI_FILTER.ganzeEndung());
				if (datei.exists())
					return datei;
				datei = new File(args[i] + XjustizContentHandler.XJUSTIZ_FILTER.ganzeEndung());
				if (datei.exists())
					return datei;
			}
		}
		return null;
	}
	// datei.getName().toLowerCase().contains(XmlTransferHandler.XML_SUFFIX)
	// datei.getName().toLowerCase().contains(BerechnungXmlDatei.DATEIENDUNG_GANZ)
	// DATEIENDUNG_GANZ
	// XmlTransferHandler.XML_SUFFIX

	/**
	 * Die Methode prüft, ob das das Programm mit Schalter -debug aufgerufen wurde.
	 * 
	 * @return true, wenn debug
	 */
	public boolean parseDebug() {
		if (args != null && args.length > 0)
			for (String s : args) {
				if ("-debug".equalsIgnoreCase(s)) {
					Kostenrechner.getLogger().info("Debug aktiviert!");
					return true;
				}
			}
		return false;
	}

}
