/**
 * ValuesAction.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;

import eu.gronos.kostenrechner.interfaces.HorcherWandelbar;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainer;

/**
 * Von {@link AbstractAction} abgeleitete Klasse, deren Konstruktoren bereits
 * Felder setzen lassen.
 *
 * @author Peter Schuster (setrok)
 * @date 31.08.2014
 *
 */
public abstract class BeschriebeneAktion extends AbstractAction implements HorcherWandelbar {
	private static final long serialVersionUID = -2990321113189187333L;
	private final LangBeschriftung beschriftung;

	/**
	 * Ein Konstruktor, der bereits Felder setzen lässt.
	 * 
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),
	 *                     {@link javax.swing.Action#MNEMONIC_KEY},
	 *                     {@link javax.swing.Action#ACCELERATOR_KEY} und
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 */
	public BeschriebeneAktion(LangBeschriftung beschriftung) {
		super();
		beschriftung.applyTo(this, new ComponentBeschrifter());
		this.beschriftung = beschriftung;
	}

	/**
	 * @return gibt {@link #beschriftung} als {@link LangBeschriftung} zurück, eine
	 *         {@link LangBeschriftung}, der auch ({@link javax.swing.Action#NAME}),
	 *         ({@link javax.swing.Action#SHORT_DESCRIPTION}),
	 *         ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen werden.
	 */
	public LangBeschriftung getBeschriftung() {
		return beschriftung;
	}

	/**
	 * Die Methode baut einen {@link JButton} mit der {@link BeschriebeneAktion} und
	 * setzt zusätzlich {@link JButton#getName()} auf die
	 * {@link NameContainer#getId()}.
	 * 
	 * @return den erstellten {@link JButton}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.HorcherWandelbar#toButton()
	 */
	public JButton toButton() {
		JButton button = new JButton();
		return (JButton) toButton(button);
	}
//	if (beschriftung.isCheckable())
//	button = new JToggleButton();
//else
//	button

	/**
	 * Die Methode versieht einen {@link JButton} oder ein abgeleitetes Objekt mit
	 * der {@link BeschriebeneAktion} und setzt zusätzlich {@link JButton#getName()}
	 * auf die {@link NameContainer#getId()}.
	 * 
	 * @param button einen {@link JButton}
	 * @return den präparierten {@link JButton}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.HorcherWandelbar#toButton(javax.swing.AbstractButton)
	 */
	public AbstractButton toButton(AbstractButton button) {
		button.setAction(this);
		button.setName(beschriftung.getId());
		return button;
	}

	/**
	 * Die Methode baut ein {@link JMenuItem} mit der {@link BeschriebeneAktion} und
	 * setzt zusätzlich {@link JMenuItem#getName()} auf die
	 * {@link NameContainer#getId()}.
	 * 
	 * @return das erstellte {@link JMenuItem}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.HorcherWandelbar#toMenuItem()
	 */
	@Override
	public JMenuItem toMenuItem() {
		JMenuItem item = new JMenuItem();// this);
		return toMenuItem(item);
	}

	/**
	 * Die Methode versieht ein {@link JMenuItem} oder ein abgeleitetes Objekt mit
	 * der {@link BeschriebeneAktion} und setzt zusätzlich
	 * {@link JMenuItem#getName()} auf die {@link NameContainer#getId()}.
	 * 
	 * @param item ein {@link JMenuItem}
	 * @return das präparierte {@link JMenuItem}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.HorcherWandelbar#toMenuItem(javax.swing.JMenuItem)
	 */
	@Override
	public JMenuItem toMenuItem(JMenuItem item) {
		item.setAction(this);
		item.setName(beschriftung.getId());
		return item;
	}
}

// System.out.println(String.format("Id: %s; Titel: %s", button.getName(),
// button.getText()));
// System.out.println(String.format("Id: %s; Titel: %s", item.getName(),
// item.getText()));
/*
 * 
 * Ein Konstruktor, der bereits Felder setzen lässt.
 * 
 * @param beschriftung eine {@link LangBeschriftung}, der auch ({@link
 * javax.swing.Action#NAME}), ({@link javax.swing.Action#SHORT_DESCRIPTION}),
 * ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen werden.
 * 
 * @param mnemonic ({@link javax.swing.Action#MNEMONIC_KEY}) The key used for
 * storing an Integer that corresponds to one of the KeyEvent key codes. The
 * value is commonly used to specify a mnemonic.
 * KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the mnemonic of myAction
 * to Cyrillic letter "Ef".
 * 
 * @Deprecated public BeschriebeneAktion(LangBeschriftung beschriftung, int
 * mnemonic) { this(beschriftung); if (!beschriftung.hasMnemonic())
 * putValue(MNEMONIC_KEY, mnemonic); }
 * 
 * Ein Konstruktor, der bereits Felder setzen lässt.
 * 
 * @param beschriftung eine {@link LangBeschriftung}, der auch ({@link
 * javax.swing.Action#NAME}), ({@link javax.swing.Action#SHORT_DESCRIPTION}),
 * ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen werden.
 * 
 * @param mnemonic () The key used for storing an Integer that corresponds to
 * one of the KeyEvent key codes. The value is commonly used to specify a
 * mnemonic. KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the mnemonic of
 * myAction to Cyrillic letter "Ef".
 * 
 * @param acceleratorKey ({@link javax.swing.Action#ACCELERATOR_KEY}) The key
 * used for storing a KeyStroke to be used
 * 
 * @Deprecated public BeschriebeneAktion(LangBeschriftung beschriftung, int
 * mnemonic, KeyStroke acceleratorKey) { this(beschriftung, mnemonic);
 * putValue(ACCELERATOR_KEY, acceleratorKey); }
 *
 * Ein Konstruktor, der bereits Felder setzen lässt.
 * 
 * @param name the name ({@link javax.swing.Action#NAME}) for the action; a
 * value of null is ignored
 * 
 * @param shortDescription ({@link javax.swing.Action#SHORT_DESCRIPTION}) The
 * key used for storing a short String description for the action, used for
 * tooltip text.
 * 
 * @param mnemonic ({@link javax.swing.Action#MNEMONIC_KEY}) The key used for
 * storing an Integer that corresponds to one of the KeyEvent key codes. The
 * value is commonly used to specify a mnemonic.
 * KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the mnemonic of myAction
 * to Cyrillic letter "Ef".
 * 
 * @param actionCommandKey ({@link javax.swing.Action#ACTION_COMMAND_KEY}) The
 * key used to determine the command String for the ActionEvent that will be
 * created when an Action is going to be notified as the result of residing in a
 * Keymap associated with a {@link JComponent}.
 * 
 * @param acceleratorKey () The key used for storing a KeyStroke to be used as
 * the accelerator for the action.
 * 
 * @Deprecated Bitte {@link #BeschriebeneAktion(LangBeschriftung, int,
 * KeyStroke)} nutzen.
 * 
 * @Deprecated public BeschriebeneAktion(String name, String shortDescription,
 * int mnemonic, String actionCommandKey, KeyStroke acceleratorKey) { this(name,
 * shortDescription, mnemonic, actionCommandKey); putValue(ACCELERATOR_KEY,
 * acceleratorKey); } Ein Konstruktor, der bereits Felder setzen lässt.
 * 
 * @param name the name ({@link javax.swing.Action#NAME}) for the action; a
 * value of null is ignored
 * 
 * @param shortDescription ({@link javax.swing.Action#SHORT_DESCRIPTION}) The
 * key used for storing a short String description for the action, used for
 * tooltip text.
 * 
 * @param mnemonic ({@link javax.swing.Action#MNEMONIC_KEY}) The key used for
 * storing an Integer that corresponds to one of the KeyEvent key codes. The
 * value is commonly used to specify a mnemonic.
 * KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the mnemonic of myAction
 * to Cyrillic letter "Ef".
 * 
 * @param actionCommandKey ({@link javax.swing.Action#ACTION_COMMAND_KEY}) The
 * key used to determine the command String for the ActionEvent that will be
 * created when an Action is going to be notified as the result of residing in a
 * Keymap associated with a {@link JComponent}.
 * 
 * @Deprecated Bitte {@link #BeschriebeneAktion(LangBeschriftung, int)} nutzen.
 * 
 * @Deprecated public BeschriebeneAktion(String name, String shortDescription,
 * int mnemonic, String actionCommandKey) { this(name, shortDescription,
 * mnemonic); putValue(ACTION_COMMAND_KEY, actionCommandKey); } Ein Konstruktor,
 * der bereits Felder setzen lässt.
 * 
 * @param name the name ({@link javax.swing.Action#NAME}) for the action; a
 * value of null is ignored
 * 
 * @param shortDescription ({@link javax.swing.Action#SHORT_DESCRIPTION}) The
 * key used for storing a short String description for the action, used for
 * tooltip text.
 * 
 * @param mnemonic ({@link javax.swing.Action#MNEMONIC_KEY}) The key used for
 * storing an Integer that corresponds to one of the KeyEvent key codes. The
 * value is commonly used to specify a mnemonic.
 * KeyEvent.getExtendedKeyCodeForChar('\u0444')) sets the mnemonic of myAction
 * to Cyrillic letter "Ef".
 * 
 * @Deprecated Bitte {@link #BeschriebeneAktion(LangBeschriftung, int)} nutzen.
 * 
 * @Deprecated public BeschriebeneAktion(String name, String shortDescription,
 * int mnemonic) { this(name, shortDescription); putValue(MNEMONIC_KEY,
 * mnemonic); } Ein Konstruktor, der bereits Felder setzen lässt.
 * 
 * @param name the name ({@link javax.swing.Action#NAME}) for the action; a
 * value of null is ignored
 * 
 * @param shortDescription ({@link javax.swing.Action#SHORT_DESCRIPTION}) The
 * key used for storing a short String description for the action, used for
 * tooltip text.
 * 
 * @Deprecated Bitte {@link #BeschriebeneAktion(LangBeschriftung)} nutzen.
 * 
 * @Deprecated public BeschriebeneAktion(String name, String shortDescription) {
 * super(name); shortDescription = Beschriftung.baueHtmlTooltip(name,
 * shortDescription); putValue(SHORT_DESCRIPTION, shortDescription); }
 */
