/*
 * DialogFensterSchliessenHorcher.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Der Horcher soll dafür sorgen, dass sich das Fenster über die
 * Schließen-Schaltfläche ("X" bzw. roter Button) verhält wie bei Abbruch
 *
 * @author Peter Schuster (setrok)
 * @date 3 May 2019
 *
 */
public class DialogFensterSchliessenHorcher extends WindowAdapter {
	private final KostenJDialog hinzufuegenDialog;

	public DialogFensterSchliessenHorcher(KostenJDialog hinzufuegenDialog) {
		this.hinzufuegenDialog = hinzufuegenDialog;
	}

	@Override
	public void windowClosing(WindowEvent e) {
		this.hinzufuegenDialog.fensterSchliessenBeiAbbruch();
	}
}