/*
 * EintragEntfernenAktion.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import eu.gronos.kostenrechner.interfaces.RowHandler;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die Action soll für die Beteiligtentabellen und die Gebührentabellen
 * einsetzbar sein und kann JPopupMenus hinzugefügt werden.
 * {@link KeyEvent#VK_E}
 *
 * @author Peter Schuster (setrok)
 * @date 5 May 2019
 *
 */
public class EintragEntfernenAktion extends BeschriebeneAktion {
	private static final long serialVersionUID = 8001075205760187469L;

	/**
	 * Konstruktor.
	 * 
	 * @param beschriftung die {@link LangBeschriftung}
	 */
	public EintragEntfernenAktion(LangBeschriftung beschriftung) {
		super(beschriftung);
	}
	// public EintragEntfernenAktion(String name, String shortDescription, int
	// mnemonic, String actionCommandKey) {
	// super(name, shortDescription, mnemonic, actionCommandKey);
	// }

	@Override
	public void actionPerformed(ActionEvent ae) {
		Object o = ae.getSource();
		// Herausfinden, welche Tabelle ruft
		if (o instanceof JMenuItem) {
			// Entweder ruft ein JPopupMenu
			JPopupMenu popup = (JPopupMenu) ((JMenuItem) o).getParent();
			entferneUeberPopupMenu(popup);
		} else if (o instanceof JTable) {
			// Oder es ruft die Tabelle selbst (über Tastatur)
			JTable table = (JTable) o;
			entferneUeberTable(table);
		}
	}
	// if (!(o instanceof JMenuItem)) {
	// return;
	// }

	/**
	 * Entfernt eine Zeile aus einer Gebühren- oder Forderungs-Tabelle.
	 * 
	 * @param table die JTable, aus der die Zeile gelöscht werden soll
	 * @param model das RowHandler-implementierende TableModel, aus der die Zeile
	 *              gelöscht werden soll
	 */
	public void entferneTabellenEintrag(JTable table, RowHandler<?> model) {
		System.out.println("EintragEntfernenAktion#entferneTabellenEintrag!");
		if (table == null || model == null || table.getSelectedRow() < 0)
			return;
		int selectedRow = table.getSelectedRow();
		model.removeRow(selectedRow);
	}

	/**
	 * Die Methode wird aufgerufen, wenn die Action von der {@link ActionMap} bzw.
	 * {@link InputMap} einer {@link JTable}, d.h. über Tastatur, ausgelöst wird.
	 * 
	 * @param table die {@link JTable}
	 */
	private void entferneUeberTable(JTable table) {
		if (table.getModel() == null || !(table.getModel() instanceof RowHandler<?>))
			return;
		RowHandler<?> model = (RowHandler<?>) table.getModel();
		entferneTabellenEintrag(table, model);
	}

	/**
	 * Die Methode wird aufgerufen, wenn die Action über ein {@link JPopupMenu}
	 * ausgelöst wird.
	 * 
	 * @param popup das {@link JPopupMenu}
	 */
	private void entferneUeberPopupMenu(JPopupMenu popup) {
		if (popup.getName() == null)
			return;// popup.setName("");
		if (popup.getName().equals("17100"))// popup.getLabel() == TeilklageruecknahmePanel.VORHER_POPUPLABEL)
			entferneTabellenEintrag(TeilklageruecknahmePanel.getInstance().tabVorher,
					TeilklageruecknahmePanel.getInstance().getGttmVorher());
		if (popup.getName().equals("17200"))// popup.getLabel() == TeilklageruecknahmePanel.NACHHER_POPUPLABEL ||
			entferneTabellenEintrag(TeilklageruecknahmePanel.getInstance().tabNachher,
					TeilklageruecknahmePanel.getInstance().getGttmNachher());
		if (popup.getName().equals("39200"))// popup.getLabel() == StreitgenossenPanel.BEKLAGTE_POPUPLABEL)
			StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(StreitgenossenPanel.getInstance().tabBeklagte,
					StreitgenossenPanel.getInstance().btmBeklagte);
		if (popup.getName().equals("39100"))// popup.getLabel() == StreitgenossenPanel.KLAEGER_POPUPLABEL)
			StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(StreitgenossenPanel.getInstance().tabKlaeger,
					StreitgenossenPanel.getInstance().btmKlaeger);
		if (popup.getName().equals("39300"))// popup.getLabel() == StreitgenossenPanel.DRITTWIDERBEKLAGTE_POPUPLABEL)
			StreitgenossenPanel.getInstance().entferneBeteiligtenEintrag(
					StreitgenossenPanel.getInstance().tabDrittwiderbeklagte,
					StreitgenossenPanel.getInstance().btmDrittwiderbeklagte);
		if (popup.getName().equals("44000"))// popup.getLabel() == ForderungsStaffelungPanel.FORDERUNGEN_POPUPLABEL)
			entferneTabellenEintrag(ForderungsStaffelungPanel.getInstance().tbForderungen,
					ForderungsStaffelungPanel.getInstance().ftm);
		if (popup.getName().equals("24200"))// popup.getLabel() == GebuehrenBerechnungPanel.RECHNER_POPUPLABEL)
			entferneTabellenEintrag(GebuehrenBerechnungPanel.getInstance().tabGebuehrenTatbestaende,
					GebuehrenBerechnungPanel.getInstance().gttmRechner);
	}
}