/*
 * HinzufuegenAbbrechenAction.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Die {@link Action} bricht den {@link HinzufuegenDialog} ab.
 *
 * @author Peter Schuster (setrok)
 * @date 5 Mar 2019
 *
 */
public class HinzufuegenAbbrechenAction extends BeschriebeneAktion {
	private final KostenJDialog dialog;
	private static final long serialVersionUID = 7626690970693233716L;

	/**
	 * Konstruktor.
	 * 
	 * @param dialog       ein {@link HinzufuegenDialog}
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),
	 *                     {@link Action#MNEMONIC_KEY},
	 *                     {@link Action#ACCELERATOR_KEY} und
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 */
	public HinzufuegenAbbrechenAction(KostenJDialog dialog, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.dialog = dialog;
	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		dialog.fensterSchliessenBeiAbbruch();
	}
}
// , int mnemonic,KeyStroke acceleratorKey, mnemonic, acceleratorKey
// String name, String shortDescription, String actionCommandKey,
// super(name, shortDescription, mnemonic, actionCommandKey, acceleratorKey);