/**
 * KontextMouseListener.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JPopupMenu;
import javax.swing.JTable;

/**
 * Soll ein Kontextmenü für die eine JTable werden. rowAtPoint(Point p) gibt die
 * Zeilennummer für einen bestimmten relativen Punkt zurück, me.getPoint des
 * MouseEvents wiederum sagt, wo sich die Maus befindet. Die Zeile wird dann
 * markiert (muss auch, sonst kann eine Action das nicht auslesen). Dann wird
 * das Kontextmenü aufgerufen, das in der Überschrift den (kurzen) Dateinamen
 * zeigt.
 * 
 * @url "http://stackoverflow.com/questions/4120862/find-the-jtable-row-on-which-a-popup-menu-has-been-invoked"
 *      Find the JTable row on which a popup menu has been invoked
 * 
 * @author Peter Felix Schuster (SchusterP2)
 * @date 11.08.2014
 */
public class KontextMouseListener implements MouseListener {
	private JPopupMenu kontextMenu;
	private JTable tabelle;

	public KontextMouseListener(JPopupMenu kontextMenu) {
		super();
		this.kontextMenu = kontextMenu;
		this.tabelle = null;
	}

	public KontextMouseListener(JTable tabelle, JPopupMenu kontextMenu) {
		this(kontextMenu);
		this.tabelle = tabelle;
		tabelle.setFillsViewportHeight(true);
	}

	@Override
	public void mouseClicked(MouseEvent me) {
		if (me.isPopupTrigger()) {
			mouseReleased(me);
		}
	}

	@Override
	public void mouseReleased(MouseEvent me) {
		if (me.isPopupTrigger())
			mousePressedOrReleased(me);
	}

	@Override
	public void mousePressed(MouseEvent me) {
		if (me.isPopupTrigger())
			mousePressedOrReleased(me);
	}
	
	

	/**
	 * Die Methode ist nötig, weil Betriebssysteme unterschiedlich mitteilen, dass
	 * der PopupTrigger (rechte Maustaste bzw. Maustaste + Tastatur) betätigt wurde.
	 * 
	 * @param me
	 */
	private void mousePressedOrReleased(MouseEvent me) {
		if (tabelle != null) {
			int i = tabelle.rowAtPoint(me.getPoint());
			if (i > -1) {
				tabelle.changeSelection(i, 1, false, false);
			}
		}
		kontextMenu.show(me.getComponent(), me.getX(), me.getY());
	}

	@Override
	public void mouseEntered(MouseEvent e) {
		// do nothing
	}

	@Override
	public void mouseExited(MouseEvent e) {
		// do nothing
	}

	/**
	 * Die Methode dient dem automatisierten Aufruf.
	 * 
	 * @return gibt {@link #kontextMenu} als {@link JPopupMenu} zurück.
	 */
	public JPopupMenu getKontextMenu() {
		return kontextMenu;
	}

}