/**
 * BeendenAction.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.Action;
import javax.swing.JOptionPane;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;

/**
 * Der Action beenden beendet den {@link Kostenrechner} und speichert Routinen,
 * die beim Schließen des Fensters eine Abfrage ausführen. {@link KeyEvent#VK_E}
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class KostenrechnerBeender extends KleinDialogAction implements WindowListener {
	private static final long serialVersionUID = -2268718567794925181L;

	/**
	 * Konstruktor.
	 * 
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public KostenrechnerBeender(LangBeschriftung beschriftung) {
		super(beschriftung);
	}
	// String name, String shortDescription, , String actionCommandKey, int mnemonic
	// name, shortDescription, , actionCommandKey, mnemonic

	@Override
	public void actionPerformed(ActionEvent e) {
		/// KostenrechnerBeender.
		beendeKostenrechner();
	}

	@Override
	public void windowClosing(WindowEvent e) {
		// KostenrechnerBeender.
		beendeKostenrechner();
	}

	@Override
	public void windowClosed(WindowEvent e) {
		Kostenrechner.getLogger().info(
				// Kostenrechner.KOSTENRECHNER_TITLE
				((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(100)).getTitle()
						+ Kostenrechner.KOSTENRECHNER_VERSION + " beendet. " + e.toString());
		System.exit(0);
	}

	/**
	 * Die Methode fragt vor dem Beenden ab
	 * 
	 * @TODO TODO in zwei Methoden aufteilen: eine für WindowClosing und die andere
	 *       für WindowClosed
	 * 
	 */
	public void beendeKostenrechner() {
		if (Kostenrechner.getInstance() == null)
			System.exit(0);
		else {
			int antwort;
			antwort = showDialog((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(77000),
					String.format("Sind Sie sicher?%nDies beendet %s!%n", // Kostenrechner.KOSTENRECHNER_TITLE
							((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(100)).getTitle()),
					JOptionPane.OK_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE);
			if (antwort == JOptionPane.OK_OPTION) {
				sofortBeenden();
			}
		}
	}
	// JOptionPane pane
	// = show(pane, getDialog());
	// setDialog(null);

	/**
	 * Die Methode beendet den {@link Kostenrechner} sofort, ohne Nachfrage. Oder
	 * nach der Nachfrage
	 */
	public void sofortBeenden() {
		Kostenrechner.getInstance().setVisible(false);
		Kostenrechner.getInstance().dispose();
	}

	@Override
	public void windowOpened(WindowEvent e) {
	}

	@Override
	public void windowIconified(WindowEvent e) {
	}

	@Override
	public void windowDeiconified(WindowEvent e) {
	}

	@Override
	public void windowActivated(WindowEvent e) {
	}

	@Override
	public void windowDeactivated(WindowEvent e) {
	}

}
//antwort = JOptionPane.showConfirmDialog(Kostenrechner.getInstance(),
//String.format("Sind Sie sicher?%nDies beendet %s!%n" + "%nLog-File: %s",
//		Kostenrechner.KOSTENRECHNER_TITLE, Kostenrechner.getLogFileName()),
//Kostenrechner.KOSTENRECHNER_TITLE + " beenden?", JOptionPane.OK_CANCEL_OPTION,
//JOptionPane.QUESTION_MESSAGE, RechnerhammerIcons.getRechnerhammer64());
// + "%nLog-File: %s", Kostenrechner.getLogFileName()
// Kostenrechner.KOSTENRECHNER_TITLE + " beenden?"
// NameContainerSammlung.BESCHRIFTUNGEN.get(77000).applyTo(dialog);
// String message = String.format("Sind Sie sicher?%nDies beendet %s!%n",
// Kostenrechner.KOSTENRECHNER_TITLE);
// Beschriftung beschriftung = (Beschriftung)
// NameContainerSammlung.BESCHRIFTUNGEN.get(77000);
// int optionType = JOptionPane.OK_CANCEL_OPTION;
// int messageType = JOptionPane.QUESTION_MESSAGE;