/**
 * TabellenZuruecksetzen.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die Klasse setzt alle Tabellen (aller Panels) wieder in den Ursprungszustand
 * zurück und schaltet dazu auch die Anzeige von Widerklagen aus.
 * {@link KeyEvent#VK_Z}
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class TabellenZuruecksetzenAction extends BeschriebeneAktion {
	private static final long serialVersionUID = 8105321861085009090L;

	/**
	 * Konstruktor.
	 * 
	 * @param mnemonic       {@link Action#MNEMONIC_KEY}
	 * @param acceleratorKey {@link Action#ACCELERATOR_KEY}
	 */
	public TabellenZuruecksetzenAction(LangBeschriftung beschriftung) {
		super(beschriftung);
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		TeilklageruecknahmePanel.getInstance().leereWerte();
		/*
		 * widerklageAnzeigen muss richtig gesetzt werden, bevor die Tabellen gesetzt
		 * werden
		 */
		StreitgenossenPanel.getInstance().setWiderKlageAnzeigen(false);
		StreitgenossenPanel.getInstance().leereWerte();
		ForderungsStaffelungPanel.getInstance().leereWerte();
		GebuehrenBerechnungPanel.getInstance().leereWerte();
	}
}
//, int mnemonic, KeyStroke acceleratorKey, mnemonic, acceleratorKey
// String name, String shortDescription, String actionCommandKey,
// name, shortDescription, actionCommandKey,
// setzeStandardGebuehren(false);
// setzeBaumbachTabellen();
// setzeForderungsTabellen();
// setzeGebuehrenRechnerTabelle(0);