/*
 * TabulatorNextAction.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

/**
 * AbstractAction, die verhindert, dass die JTable die Tabulartortaste "frisst".
 * 
 * @author Peter Schuster (setrok)
 * @date 5 May 2019
 * 
 * @url "http://www.coderanch.com/t/342895/GUI/java/JTable-focus" * aus: Big
 *      Moose Saloon, A friendly place for programming greenhorns!
 * 
 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
 *
 */
public class TabulatorNextAction extends AbstractAction {
	private static final long serialVersionUID = -6095777609039741786L;

	public void actionPerformed(ActionEvent ae) {
		KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
	}
}