/**
 * AssistentBkUnterliegenHorcher.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;

/**
 * Wenn nicht ausgewhält, muss die Liste ausgegraut werden und die Werte /
 * Markierung geleert werden
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class AssistentBkUnterliegenHorcher implements ChangeListener {
	private final JList<Beteiligter> list;
	private final JFormattedTextField textField;

	/**
	 * @param list      eine {@link JList} von {@link Beteiligter}
	 * @param textField das korrespondierende {@link JFormattedTextField}
	 */
	public AssistentBkUnterliegenHorcher(JList<Beteiligter> list, JFormattedTextField textField) {
		this.list = list;
		this.textField = textField;
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		boolean selected = ((JCheckBox) e.getSource()).isSelected();
		list.setEnabled(selected);
		textField.setEnabled(selected);
		if (!selected) {
			list.setSelectedIndex(-1);
			textField.setText("");
		}
	}
}