/**
 * AssistentWbkUnterliegenHorcher.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import eu.gronos.kostenrechner.model.baumbach.ProtoBeteiligtenWerte;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;

/**
 * Horcher, damit sich die Checkbox so verhält:
 * 
 * Wenn nicht ausgewählt, muss die Liste ausgegraut werden und die Werte /
 * Markierung geleert werden
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class AssistentWbkUnterliegenHorcher implements ChangeListener {
	// private final BaumbachAssistentDialog dialog;
	// this.dialog = dialog;
	// = dialog.liWkGesamtschuldner;
	// = dialog.ftfWkUnterliegen;
	private final JList<Beteiligter> liste;
	private final JFormattedTextField textField;
	private final ProtoBeteiligtenWerte sonstigeWerte;

	public AssistentWbkUnterliegenHorcher(JList<Beteiligter> liste, JFormattedTextField textField,
			ProtoBeteiligtenWerte sonstigeWerte) {
		this.liste = liste;
		this.textField = textField;
		this.sonstigeWerte = sonstigeWerte;
	}

	@Override
	public void stateChanged(ChangeEvent e) {
		boolean b = ((JCheckBox) e.getSource()).isSelected();
		liste.setEnabled(b);
		textField.setEnabled(b);
		if (!b) {
			liste.setSelectedIndex(-1);
			textField.setText(Double.toString(sonstigeWerte.wkGesamtUnterliegen));
		}

	}
}