/**
 * StreitgenossenBkAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.interfaces.DialogLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BaumbachBeteiligter;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.baumbach.BeteiligtenHinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die {@link Action} fügt, je nach Auswahl im Konstruktor
 * {@link #StreitgenossenBeteiligterNeuAction(StreitgenossenPanel, int, String, String, int, String)},
 * einen neuen Kläger hinzu, {@link KeyEvent#VK_K}, einen neuen (einzelnen)
 * Beklagten hinzu, {@link KeyEvent#VK_B}, oder einen neuen Drittwiderbeklagten
 * hinzu, {@link KeyEvent#VK_D}.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenBeteiligterNeuAction extends BeschriebeneAktion implements DialogLieferant {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = -6505409262360418812L;
	private int typ;
	private BeteiligtenHinzufuegenDialog dialog = null;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        {@link StreitgenossenPanel}
	 * @param typ          Welcher Beteiligtentyp soll hinzugefügt werden:
	 *                     {@link Beteiligter#KLAEGER}, {@link Beteiligter#BEKLAGTE}
	 *                     oder {@link Beteiligter#DRITTWIDERBEKLAGTE}
	 * @param beschriftung eine {@link LangBeschriftung} mit {@link Action#NAME},
	 *                     {@link Action#SHORT_DESCRIPTION},
	 *                     {@link Action#MNEMONIC_KEY} und
	 *                     {@link Action#ACTION_COMMAND_KEY}
	 */
	public StreitgenossenBeteiligterNeuAction(StreitgenossenTabellenBehandelnd panel, int typ,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
		this.typ = typ;
	}
	// super(name, shortDescription, mnemonic, mnemonic, actionCommandKey);
	// String name, String shortDescription,, String actionCommandKey, int mnemonic
	// , KeyEvent.VK_K, KeyEvent.VK_B, KeyEvent.VK_D

	@Override
	public void actionPerformed(ActionEvent ae) {
		beteiligtenHinzufuegen(panel.getTableModel(typ));
	}

	/**
	 * @return 
	 * @return gibt den {@link BeteiligtenHinzufuegenDialog} zurück, den die Aktion
	 *         erstellt.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.DialogLieferant#getDialog()
	 */
	@Override
	public BeteiligtenHinzufuegenDialog getDialog() {
		// System.out.println("Gesetzt!");
		return dialog;
	}

	/**
	 * Die Methode beteiligtenHinzufuegen dient dazu, den JDialog
	 * BeteiligtenHinzufuegen zum Hinzufügen eines neuen BaumbaachBeteiligten
	 * auszulesen. Dazu liest sie BaumbachTableModel aus, sofern dieses Werte
	 * enthält, kopiert den letzten Eintrag und fügt den Rückgabewert wieder als
	 * neuen Eintrag der Tabelle hinzu.
	 * 
	 * @param btm das {@link BeteiligtenTableModel}, in das der Beteiligte eingefügt
	 *            werden soll.
	 */
	private void beteiligtenHinzufuegen(BeteiligtenTableModel btm) {
		BaumbachBeteiligter bt;
		if (btm.getRowCount() > 0)
			bt = btm.getRow(btm.getRowCount() - 1);
		else
			bt = new BaumbachBeteiligter(btm.getBeteiligtenTyp(), Beteiligter.WEIBLICH, 0.0, 0.0, false);
		setDialog(new BeteiligtenHinzufuegenDialog(Kostenrechner.getInstance(), bt, panel.isWiderKlageAnzeigen()));
		bt = dialog.showDialogAndAsk();
		dialog = null;
		/*
		 * Wenn versucht wird, mehr als einen Kläger zum btm hinzuzufügen, wirft dieses
		 * eine IllegalArgumentException
		 */
		if (bt != null)
			try {
				btm.addRow(bt);
			} catch (IllegalArgumentException e) {
				FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
			}
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link BeteiligtenHinzufuegenDialog}.
	 * @return
	 */
	private BeteiligtenHinzufuegenDialog setDialog(BeteiligtenHinzufuegenDialog dialog) {
		this.dialog = dialog;
		return dialog;
	}
}