/**
 * StreitgenossenGesamtschuldDwbkExtractAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.BaumbachBeteiligtenListe;
import eu.gronos.kostenrechner.model.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die {@link Action} geht die Beteiligten einer Seite durch und guckt, ob sie
 * z.T. gesamtschuldnerisch verurteilt wurden. {@link KeyEvent#VK_W}
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenGesamtschuldDwbkExtractAction extends BeschriebeneAktion {
	private final StreitgenossenTabellenBehandelnd handler;
	private static final long serialVersionUID = 8105321861085009090L;

	/**
	 * Konstruktor.
	 * 
	 * @param handler  {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenGesamtschuldDwbkExtractAction(StreitgenossenTabellenBehandelnd handler,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
	}
	// String name,String shortDescription, , String actionCommandKey, int mnemonic,
	// KeyEvent.VK_W
	// super(name, shortDescription, mnemonic, actionCommandKey, mnemonic);

	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO ALLES PRÜFEN!
		// WICHTIG: Vorher echte Kopie anlegen!
		BaumbachBeteiligtenListe beteiligte = new BaumbachBeteiligtenListe();
		BeteiligtenTableModel btmKlaeger = handler.getTableModel(Beteiligter.KLAEGER);
		BeteiligtenTableModel btmDrittwiderbeklagte = handler.getTableModel(Beteiligter.DRITTWIDERBEKLAGTE);
		beteiligte.addAll(btmKlaeger.getAllValues());// panel.
		beteiligte.addAll(btmDrittwiderbeklagte.getAllValues());// panel.
		if (beteiligte == null || beteiligte.size() < 2)
			return;
		BaumbachGesamtschuldnerschaft gesamtschuldnerschaft = beteiligte
				.extrahiereGesamtschuldnerschaft(btmDrittwiderbeklagte.getBeteiligtenTyp());// panel.
		if (gesamtschuldnerschaft != null) {
			btmDrittwiderbeklagte.addRow(gesamtschuldnerschaft);// panel.
			// System.out.println
			Kostenrechner.getLogger().info("Schleife");
			// Rekursion, sofern Rückgabe nicht null: Bei Dwbk nicht gut...
			actionPerformed(e);
			// Und das Model muss was von der Änderung mitbekommen.
			btmKlaeger.fireTableDataChanged();// panel.
			btmDrittwiderbeklagte.fireTableDataChanged();// panel.
		} else {
			Kostenrechner.getLogger().info("Schleife endet!");
		}
	}
}