package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.interfaces.DialogLieferant;
import eu.gronos.kostenrechner.model.baumbach.BaumbachGesamtschuldnerschaft;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.baumbach.GesamtschuldnerDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Die {@link Action} fügt eine gesamtschuldnerische Verurteilung auf
 * Kläger-/Drittwiderbeklagtenseite hinzu.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenGesamtschuldnerDwbkAction extends BeschriebeneAktion implements DialogLieferant  {
	private final StreitgenossenPanel panel;
	private static final long serialVersionUID = -6637467913455344657L;
	private GesamtschuldnerDialog dialog = null;

	/**
	 * Konstruktor.
	 * 
	 * @param panel    {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenGesamtschuldnerDwbkAction(StreitgenossenPanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}
	// String name, String shortDescription,, String actionCommandKey
	// super(name,,int mnemonic
	// shortDescription, mnemonic, actionCommandKey);, mnemonic, KeyEvent.VK_L

	@Override
	public void actionPerformed(ActionEvent ae) {
		try {
			//GesamtschuldnerDialog gesamtschuldnerDialog = gesamtschuldnerDialog
			setDialog(new GesamtschuldnerDialog(panel.getKostenrechner(),
					panel.btmKlaeger.getAllValues(), panel.btmDrittwiderbeklagte.getAllValues(),
					panel.getExtrahierenAktion(Beteiligter.DRITTWIDERBEKLAGTE)));
			BaumbachGesamtschuldnerschaft bt = getDialog().showDialogAndAsk();
			if (bt != null)
				panel.btmDrittwiderbeklagte.addRow(bt);
		} catch (IllegalArgumentException iae) {
			// Meldung, wenn noch keine Beteiligten in Tabelle
			FehlerHelper.zeigeFehler(iae.getLocalizedMessage(), iae);
			// StreitgenossenPanel.FEHLER_GESAMTSCHULDNERSCHAFT,
		} finally {
			setDialog(null);
		}
	}

	/**
	 * @return gibt {@link #dialog} als {@link GesamtschuldnerDialog} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.DialogLieferant#getDialog()
	 */
	public GesamtschuldnerDialog getDialog() {
		return dialog;
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link GesamtschuldnerDialog}.
	 */
	private void setDialog(GesamtschuldnerDialog dialog) {
		this.dialog = dialog;
	}

}