/**
 * StreitgenossenWiderklageAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.DialogLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.baumbach.Widerklage;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;
import eu.gronos.kostenrechner.view.baumbach.WiderklageHinzufuegenDialog;

/**
 * Die {@link Action} ruft einen kleinen {@link HinzufuegenDialog} der Klasse
 * {@link WiderklageHinzufuegenDialog} für die Widerklage auf.
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenWiderklageAction extends BeschriebeneAktion implements DialogLieferant {
	private final StreitgenossenTabellenBehandelnd panel;
	private static final long serialVersionUID = 7753262660993032427L;
	private final WiderklageHinzufuegenDialog dialog;

	/**
	 * Konstruktor.
	 * 
	 * @param panel    {@link StreitgenossenPanel}
	 * @param mnemonic {@link Action#MNEMONIC_KEY}
	 */
	public StreitgenossenWiderklageAction(StreitgenossenTabellenBehandelnd panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
		dialog = new WiderklageHinzufuegenDialog(panel.getKostenrechner());
	}
	// , mnemonic,int mnemonic, KeyEvent.VK_W
	// String name, String shortDescription,, String actionCommandKey super(name,
	// shortDescription, mnemonic, actionCommandKey);

	@Override
	public void actionPerformed(ActionEvent ae) {
		// boolean[] b = hd.showDialog();
		Widerklage widerklage = dialog.showDialogAndAsk();
		if (widerklage == null)
			return;
		/*
		 * panel.setWiderKlageAnzeigen(b[0]);
		 * panel.btmKlaeger.setWiderKlageAnzeigen(b[0]);
		 * panel.btmDrittwiderbeklagte.setWiderKlageAnzeigen(b[0]);
		 * panel.btmBeklagte.setWiderKlageAnzeigen(b[0]);
		 * panel.setWirtschaftlichIdentisch(b[1]);
		 */
		panel.setWiderKlageAnzeigen(widerklage.isVorhanden());
		panel.getTableModel(Beteiligter.KLAEGER).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmKlaeger
		panel.getTableModel(Beteiligter.DRITTWIDERBEKLAGTE).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmDrittwiderbeklagte
		panel.getTableModel(Beteiligter.BEKLAGTE).setWiderKlageAnzeigen(widerklage.isVorhanden());// btmBeklagte
		panel.setWirtschaftlichIdentisch(widerklage.isWirtschaftlichIdentisch());
	}

	/**
	 * @return gibt den {@link WiderklageHinzufuegenDialog} zurück, den die Aktion
	 *         erstellt.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.DialogLieferant#getDialog()
	 */
	@Override
	public WiderklageHinzufuegenDialog getDialog() {
		return dialog;
	}
}