/**
 * StreitgenossenXJustizLesenAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.baumbach;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.files.XjustizContentHandler;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.interfaces.StreitgenossenTabellenBehandelnd;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.BerechnungFileChooser;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.baumbach.BaumbachAssistentDialog;
import eu.gronos.kostenrechner.view.baumbach.StreitgenossenPanel;

/**
 * Der AbstractAction importiert eine XJustiz-Datei und ruft dann den
 * Baumbach-Assistenten auf. {@link KeyEvent#VK_X}
 *
 * @author Peter Schuster (setrok)
 * @date 10.11.2018
 *
 */
public class StreitgenossenXJustizLesenAction extends BeschriebeneAktion implements AbfrageLieferant {
	private final StreitgenossenTabellenBehandelnd handler;
	private final JFrame frame;
	private static final long serialVersionUID = 3372100502718641247L;
	private KostenFileChooser fileChooser = null;

	/**
	 * Der Konstruktor setzt die Felder der {@link BeschriebeneAktion}
	 * 
	 * @param handler      ein Bezug auf das aufrufende {@link StreitgenossenPanel}
	 * @param frame        Bezug auf {@link Kostenrechner}
	 * @param beschriftung eine {@link LangBeschriftung} mit
	 *                     ({@link javax.swing.Action#MNEMONIC_KEY}) und
	 *                     ({@link javax.swing.Action#ACCELERATOR_KEY})
	 */
	public StreitgenossenXJustizLesenAction(StreitgenossenTabellenBehandelnd handler, JFrame frame,
			LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
		this.frame = frame;
	}

	/**
	 * Die Methode für einen Öffnen-Dialog für Xjustiz-Dateien. Mit einem
	 * {@link KostenFileChooser}, weil der sich auch den Pfad merkt.
	 * 
	 * @param ae ein {@link ActionEvent}
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent ae) {
		File auswahl = null;
		VerfahrensDatenContainer container = null;
		// BaumbachAssistentDialog bad = null;

		fileChooser = new KostenFileChooser(XjustizContentHandler.XJUSTIZ_FILTER,
				(Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
		int ergebnis = fileChooser.showOpenDialog(frame);// null);

		if (ergebnis == JFileChooser.APPROVE_OPTION) {
			// Bei Auswahl: auslesen
			auswahl = fileChooser.getSelectedFile();
			fileChooser = null;
			container = xJustizLesen(auswahl);
			// jetzt Werte setzen
			if (container != null && container.streitgenossen != null) {
				this.handler.setzeWerte(container.streitgenossen);
				handler.requestFocusInWindow();
			}
		} else {
			// Bei Abbruch: nix
			fileChooser = null;
			// bad = new BaumbachAssistentDialog(this.frame,
			// this.handler.isWiderKlageAnzeigen());
			// container = bad.showDialogAndAsk();
		}
	}

	/**
	 * Ruft für eine gegebene Datei den Xjustiz-Import von
	 * {@link XjustizContentHandler} auf und im Anschluss den
	 * {@link BaumbachAssistenzDialog}, um das Ergebnis zu verarbeiten.
	 * 
	 * @param datei ein File
	 * @return einen {@link VerfahrensDatenContainer}
	 */
	public VerfahrensDatenContainer xJustizLesen(File datei) {
		Kostenrechner.getLogger().info("xJustizLesen!");
		BaumbachAssistentDialog bad;
		VerfahrensDatenContainer container = null;
		try {
			container = new XjustizContentHandler(XjustizContentHandler.vonFileNachURI(datei)).parseXjustiz();
		} catch (ParserConfigurationException | SAXException | IOException e) {
			FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
		}
		if (container != null) {
			/*
			 * TODO Die übrigen Streitwertfelder erst einmal mit dem Wert aus der
			 * XJustiz-Datei bestücken. So stehen sie schon einmal drin, auch wenn der
			 * Assistent später abgebrochen wird.
			 */
			// TODO setzeAlleStreitwertTextfelder(vdc);
			Kostenrechner.getLogger().info("container != null --> BaumbachAssistent mit container bauen");
			bad = new BaumbachAssistentDialog(this.frame, container);
		} else {
			bad = new BaumbachAssistentDialog(this.frame, handler.isWiderKlageAnzeigen());
		}
		Kostenrechner.getLogger().info("BaumbachAssistentDialog aufrufen");
		container = bad.showDialogAndAsk();
		Kostenrechner.getLogger()
				.info(String.format("BaumbachAssistentDialog ist fertig; container == null? %s!", container == null));
		/*
		 * Wenn der Assistent mit OK beendet wird, dann die übrigen Streitwertfelder mit
		 * dem Streitwert füllen
		 */
		return container;
	}

	/**
	 * Die Methode leitet die Abfrage auf den {@link BerechnungFileChooser} um.
	 * 
	 * @return den {@link KostenFileChooser#getDialog()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public JDialog getDialog() {
		if (fileChooser != null) {
			return fileChooser.getDialog();
		}
		return null;
	}

}

// JFileChooser jfc = new JFileChooser();
// jfc.setFileFilter(new FileNameExtensionFilter("XML", "xml"));
// XjustizFileChooser();
// , mnemonic, acceleratorKey, int mnemonic, KeyStroke acceleratorKey
// String name,String shortDescription, String actionCommandKey,
// name, shortDescription, mnemonic, actionCommandKey, acceleratorKey);
// , KeyEvent.VK_X, KeyStroke.getKeyStroke(KeyEvent.VK_O, Kostenrechner.ctrlMask
// + ActionEvent.SHIFT_MASK)