/*
 * HtmlHelper.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext.NamedStyle;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS.Attribute;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.view.FontHelfer;
import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Die Klasse kann den Inhalt einer HTML-Datei einlesen und ihn formatiert in
 * das übergebene {@link StyledDocument} schreiben sowie CSS-Dateien einlesen
 * und zuweisen.
 *
 * @author Peter Schuster (setrok)
 * @date 17 Apr 2019
 *
 */
public class HtmlWerkzeugKasten extends HTMLEditorKit {
	private static final long serialVersionUID = 1919064068820341048L;
	public static final String KOSTENTENOR_CSS = "resources/kostentenor.css";
	private static StyleSheet cssSheet = null;
	private StyleSheet sheet = null;
	private static final String EM_FINDER = "(\\d+|\\d+\\.\\d+)em";
	// private static StyleSheet reserveStyleSheet = null;
	private StyledDocument doc;

	/**
	 * Die Methode setzt in einer {@link JTextPane} das {@link HTMLEditorKit} und
	 * das {@link StyledDocument} und lädt die CSS.
	 * 
	 * @param textPane die {@link JTextPane}
	 */
	@Override
	public void install(JEditorPane textPane) {
		super.install(textPane);
		createDefaultDocument();
		if (textPane instanceof JTextPane) {
			((JTextPane) textPane).setStyledDocument(doc);
		} else {
			textPane.setDocument(doc);
		}
		// neu
		textPane.setEditable(false);
		textPane.addHyperlinkListener(KostenJDialog.HYPERLINK_LISTENER);
	}

	// this.doc = (StyledDocument) super.createDefaultDocument();
	// createDefaultDocument(textPane);
	// createStyles();

	// final HTMLEditorKit kit = (HTMLEditorKit) textPane.getEditorKit();
	// helper.
	// , kit

	// HTMLEditorKit kit = new HTMLEditorKit();
	// HTMLEditorKit kit = (HTMLEditorKit) textPane.getEditorKit();
	// , kit
	// textPane.setEditorKit(kit);
	// StyledDocument doc = (StyledDocument) kit.createDefaultDocument();
	// textPane.setStyledDocument(doc);
	// kit
	// leseCss(cssfilename, kit);, kit

	// , HTMLEditorKit kit
	/*
	 * @param kit das {@link HTMLEditorKit} des JTextPanes, das gefüllt werden soll.
	 */

	/**
	 * Die Methode setzt in einer {@link JTextPane} das {@link HTMLEditorKit} und
	 * das {@link StyledDocument} und lädt die CSS.
	 * 
	 * @param textPane die {@link JTextPane}
	 * @return das {@link StyledDocument}, namentlich das
	 *         {@link EditorKit#createDefaultDocument()} des {@link HTMLEditorKit}s
	 */
	// private StyledDocument createDefaultDocument(JEditorPane textPane) {
	// textPane.setEditorKit(this);
	// StyledDocument doc = (StyledDocument) super.createDefaultDocument();
	// return doc;
	// }
	public Document createDefaultDocument() {
		if (doc != null) {
			return doc;
		}
		this.doc = (StyledDocument) super.createDefaultDocument();
		return doc;
	}

	/**
	 * Die Methode lädt die HTML-Datei und fügt sie ins {@link StyledDocument}
	 * {@link #getDocument()} ein. Danach wird der Cursor nach oben gesetzt.
	 * 
	 * @param htmlfilename der Name der HTML-Datei in den resources
	 * @param textPane     die {@link JTextPane}
	 * @throws BadLocationException
	 */
	public void read(final String htmlfilename, final JTextPane textPane) {
		read(htmlfilename, doc);
		textPane.setCaretPosition(0);
		textPane.repaint();
	}

	// StyledDocument doc = createDefaultDocument(textPane);
	// CSS nach der HTML laden ist besser
	// createStyles();
	// Caret ganz nach oben setzen

	// HTMLEditorKit kit = new HTMLEditorKit();
	// HTMLEditorKit kit = (HTMLEditorKit) textPane.getEditorKit();
	// , kit
	// textPane.setEditorKit(kit);
	// StyledDocument doc = (StyledDocument) kit.createDefaultDocument();
	// textPane.setStyledDocument(doc);
	// kit
	// leseCss(cssfilename, kit);, kit
	// , HTMLEditorKit kit
	/*
	 * @param kit das {@link HTMLEditorKit} des JTextPanes, das gefüllt werden soll.
	 */
	// HTMLEditorKit kit = new HTMLEditorKit();
	// HTMLEditorKit kit = (HTMLEditorKit) textPane.getEditorKit();
	// , kit
	// textPane.setEditorKit(kit);
	// StyledDocument doc = (StyledDocument) kit.createDefaultDocument();
	// textPane.setStyledDocument(doc);
	// kit
	// leseCss(cssfilename, kit);, kit
	// , HTMLEditorKit kit
	/*
	 * @param kit das {@link HTMLEditorKit} des JTextPanes, das gefüllt werden soll.
	 */

	/**
	 * Die Methode dient dazu, das Standard {@link HTMLEditorKit#getStyleSheet()} zu
	 * schonen.
	 * 
	 * @param sheet d. {@link #sheet}, d. gesetzt werden soll als
	 *              {@link StyleSheet}.
	 * 
	 * @see javax.swing.text.html.HTMLEditorKit#setStyleSheet(javax.swing.text.html.StyleSheet)
	 */
	@Override
	public void setStyleSheet(StyleSheet sheet) {
		this.sheet = sheet;
	}

	/**
	 * Die Methode dient dazu, das Standard {@link HTMLEditorKit#getStyleSheet()} zu
	 * schonen.
	 * 
	 * @return gibt {@link #sheet} als {@link StyleSheet} zurück.
	 * 
	 * @see javax.swing.text.html.HTMLEditorKit#getStyleSheet()
	 */
	@Override
	public StyleSheet getStyleSheet() {
		if (this.sheet == null) {
			createStyles();
			return sheet;
		} else {
			return sheet;
		}
	}

	/**
	 * Die Methode dient dazu, das Standard {@link HTMLEditorKit#getStyleSheet()} zu
	 * schonen.
	 * 
	 * @param sheet ein {@link StyleSheet}, das in der ELternklasse gesetzt werden
	 *              soll.
	 * 
	 * @see javax.swing.text.html.HTMLEditorKit#setStyleSheet(javax.swing.text.html.StyleSheet)
	 */
	protected void setDefaultStyleSheet(StyleSheet sheet) {
		super.setStyleSheet(sheet);
	}

	/**
	 * Die Methode dient dazu, das Standard {@link HTMLEditorKit#getStyleSheet()} zu
	 * schonen.
	 * 
	 * @return das {@link HTMLEditorKit#getStyleSheet()} der Elternklasse
	 * 
	 * @see javax.swing.text.html.HTMLEditorKit#getStyleSheet()
	 */
	private StyleSheet getDefaultStyleSheet() {
		return super.getStyleSheet();
	}

	/**
	 * Die Methode dient dazu, eine CSS-Datei aus den Resources einzulesen und dem
	 * {@link HTMLEditorKit} zuzuweisen.
	 * 
	 * @param kit das {@link HTMLEditorKit} des JTextPanes, das gefüllt werden soll.
	 * 
	 * @url {@link https://stackoverflow.com/questions/17840914/how-to-provide-functionalty-for-changing-the-background-color-of-text-parts-in-h/18080249#18080249}
	 * @url {@link https://stackoverflow.com/questions/11177126/text-html-in-a-jtextpane-netbeans/11177448#11177448}
	 * @url {@link https://stackoverflow.com/questions/18448671/how-to-avoid-concurrentmodificationexception-while-removing-elements-from-arr}
	 *      - sonst {@link ConcurrentModificationException}
	 */
	private void createStyles() {
		URL css = getClass().getClassLoader().getResource(KOSTENTENOR_CSS);
		setStyleSheet(new StyleSheet());
		getStyleSheet().addStyleSheet(getDefaultStyleSheet());
		final List<String> oldStyleNames = collectStyleNamesList(getStyleSheet());

		if (cssSheet == null) {
			// erst jetzt die gewünschte CSS importieren
			cssSheet = new StyleSheet();
			cssSheet = cssReinziehen(css, cssSheet);
		}
		final List<String> newStyleNames = collectStyleNamesList(cssSheet);
		leereStyleSheet(super.getStyleSheet(), oldStyleNames, newStyleNames);

		// zum Schluss das eingelesene Sheet dem neuen StyleSheet hinzufügen
		getStyleSheet().addStyleSheet(cssSheet);
	}

	// , HTMLEditorKit kit
	// List<String> names = collectStyleNamesList(kit.getStyleSheet());
	// kit kit
	// kit//// || reserveStyleSheet == null
	// leereStyleSheet(super.getStyleSheet(), oldStyleNames);
	// if (reserveStyleSheet == null) {
	// reserveStyleSheet = super.getStyleSheet();
	// reserveStyleSheet = new StyleSheet();
	// reserveStyleSheet.addStyleSheet(super.getStyleSheet());
	// } else {
	// super.setStyleSheet(new StyleSheet());
	// super.getStyleSheet().addStyleSheet(reserveStyleSheet);
	// }
	// super.setStyleSheet(new StyleSheet());
	// super.getStyleSheet().addStyleSheet(reserveStyleSheet);
	// super.getStyleSheet().addStyleSheet(cssSheet);

	// super.setStyleSheet(cssSheet);
	// super.getStyleSheet().addStyleSheet(reserveStyleSheet);

//	private StyleSheet clone(StyleSheet sheet) {
//		StyleSheet newSheet = new StyleSheet();
//		List<String> names = collectStyleNamesList(sheet);
//		for (String name : names) {
//			newSheet.addStyle(name, sheet.getStyle(name));
//		}
//		return newSheet;
//	}

	/**
	 * Liest den Inhalt einer HTML-Datei ein und schreibt ihn formatiert in das
	 * übergebene {@link StyledDocument}
	 * 
	 * @param name der Name der HTML-Datei in den resources
	 * @param doc  das {@link StyledDocument} des JTextPanes, das gefüllt werden
	 *             soll
	 * 
	 * @see javax.swing.text.DefaultEditorKit#read(InputStream, Document, int)
	 */
	private void read(String name, StyledDocument doc) {
		InputStream is;
		try {
			is = getClass().getClassLoader().getResourceAsStream(name);
			doc.remove(0, doc.getLength());
			doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
			// kit
			super.read(is, doc, 0);
		} catch (FileNotFoundException e) {
			FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
		} catch (IOException e) {
			FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
		} catch (BadLocationException e) {
			FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
		}
	}

	/**
	 * Die Methode entfernt die in names aufgeführten Styles aus dem sheet.
	 * 
	 * @param sheet das {@link StyleSheet} aus dem {@link EditorKit}
	 * @param names eine {@link List} von {@link String}s mit den Namen der Styles
	 */
	private void leereStyleSheet(StyleSheet sheet, List<String> names, List<String> newNames) {
		// Danach kann ich erst entfernen, sonst ConcurrentModificationException
		Iterator<String> iter = names.iterator();
		while (iter.hasNext()) {
			String name = iter.next();
			if (newNames.contains(name)) {
				sheet.removeStyle(name);
			}
		}
	}

	/**
	 * Die Methode sammelt die Namen der Styles im {@link StyleSheet} mit
	 * {@link StyleSheet#getStyleNames()} und gibt sie als {@link List} von
	 * {@link String}s zurück.
	 * 
	 * @param sheet das {@link StyleSheet} aus dem {@link EditorKit}
	 * @return eine {@link List} von {@link String}
	 */
	private List<String> collectStyleNamesList(StyleSheet sheet) {
		Enumeration<?> e = sheet.getStyleNames();
		List<String> names = new ArrayList<String>();
		// jetzt sammeln und zur List nehmen
		while (e.hasMoreElements()) {
			String str = (String) e.nextElement();
			names.add(str);
		}
		return names;
	}
//		Enumeration<?> e = kit.getStyleSheet().getStyleNames();
//		List<String> names = new ArrayList<String>();
//		// Erst sammeln
//		while (e.hasMoreElements()) {
//			String str = (String) e.nextElement();
//			names.add(str);
//		}

	/**
	 * Die Methode dient dazu, die CSS-Datei zu lesen über
	 * {@link StyleSheet#importStyleSheet(URL)} und mit
	 * {@link #applySystemConstants(StyleSheet)} eine Standardschriftgröße aus der
	 * Umgebung zu setzen.
	 * 
	 * @param css   eine {@link URL} mit der CSS-Datei
	 * @param sheet das {@link StyleSheet}
	 * @return das {@link StyleSheet}
	 */
	private StyleSheet cssReinziehen(URL css, StyleSheet sheet) {
		Kostenrechner.getLogger().info("cssReinziehen");
		sheet.importStyleSheet(css);

		// Standard-Schriftart setzen
		applySystemConstants(sheet);

		// return sheet;
		return baueSheetMitFonts(sheet, collectStyleNamesList(sheet));
	}

	/**
	 * Die Methode sieht sich den {@link StyleSheet} Stück für Stück an und sucht
	 * aus allen Font-Angaben den ersten heraus, der auch auf dem System installiert
	 * ist.
	 * 
	 * @param sheet das {@link StyleSheet}, das die Methode untersuchen soll
	 * @param names das Ergebnis von {@link #collectStyleNamesList(StyleSheet)}
	 * @return ein neues {@link StyleSheet} mit existierenden Font-Namen.
	 */
	private StyleSheet baueSheetMitFonts(StyleSheet sheet, List<String> names) {
		String[] installedFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
		StyleSheet newSheet = new StyleSheet();
		final StringBuilder cssText = new StringBuilder();
		for (String name : names) {
			Style rule = sheet.getRule(name);
			StringBuilder builder = new StringBuilder(name + " {");
			Enumeration<?> ruleEnumerator = rule.getAttributeNames();
			while (ruleEnumerator.hasMoreElements()) {
				Object element = ruleEnumerator.nextElement();
				if ((element instanceof StyleConstants)) {
					if (rule.getAttribute(element) instanceof NamedStyle) {
						NamedStyle named = (NamedStyle) rule.getAttribute(element);

						Enumeration<?> namedStylesEnumerator = named.getAttributeNames();
						while (namedStylesEnumerator.hasMoreElements()) {
							Object nextE = namedStylesEnumerator.nextElement();
							Object attribute = named.getAttribute(nextE);
							if (Attribute.FONT_FAMILY.equals(nextE)) {
								builder.append(String.format("%s: %s;", nextE.toString(),
										pickeFontName(attribute.toString(), installedFonts)));
							} else if (Attribute.MARGIN.equals(nextE) || Attribute.MARGIN_LEFT.equals(nextE)
									|| Attribute.MARGIN_RIGHT.equals(nextE) || Attribute.MARGIN_BOTTOM.equals(nextE)
									|| Attribute.MARGIN_TOP.equals(nextE)) {
								// Scheint immer nur 0 einzulesen :-(
								// Deshalb ignorieren
								System.out.println("Attribute.MARGIN.equals(nextE) " + attribute.toString() + " "
										+ attribute.getClass().toString());
							} else {
								final String verwandleGroesse = verwandleGroessen(attribute.toString());
								builder.append(String.format("%s: %s;", nextE.toString(), verwandleGroesse));
							}
						}

					}
				}
			}
			builder.append("}");
			String string = builder.toString();
			cssText.append(string + System.lineSeparator());
			newSheet.addRule(string);
		}
		Kostenrechner.getLogger().info(cssText.toString());
		return newSheet;
	}

	/**
	 * Die Methode rechnet eine relative Größe mit der Maßeinheit "em" in eine
	 * absolute Größe in Punkt um.
	 * 
	 * @param string der Suchstring
	 * @return der umgewandelte String, bei dem alle Vorkommnisse von 'em'-Größen
	 *         umgerechnet wurden.
	 */
	private String verwandleGroessen(String string) {
		StringBuilder builder = new StringBuilder();
		Pattern pattern = Pattern.compile(EM_FINDER);
		Matcher matcher = pattern.matcher(string);
		int start = -1;
		int end = -1;
		int found = 0;
		int last = 0;
		while (matcher.find()) {
			start = matcher.start();
			end = matcher.end();
			final String gefunden = (String) string.subSequence(start, end - 2);
			int size = verwandleGroesse(gefunden);
			if (start > 0)
				builder.append(string.subSequence(last, start - 1));
			builder.append(String.format("%dpx", size));
			found++;
			last = end - 1;
		}
		if (found > 0 && end < (string.length() - 1)) {
			builder.append(string.subSequence(end, string.length() - 1));
		}
		if (found > 0)
			return builder.toString();
		else
			return string;
	}

	/**
	 * Die Methode rechnet eine relative Größe mit der Maßeinheit "em" in eine
	 * absolute Größe in Punkt um.
	 * 
	 * @param gefunden der {@link String} mit der em-Größe ohne die Maßeinheit 'em'
	 * @return die Größe in px als <code>int</code>
	 */
	private int verwandleGroesse(final String gefunden) {
		float fliess = Float.parseFloat(gefunden);
		int size = (int) (baseFont().getSize() * fliess * FontHelfer.zoom);
		System.out.printf("Gefunden '%s' wird zu float %,2f und dann zu int %d.%n", gefunden, fliess, size);
		return size;
	}

	// Object attributeFF = named.getAttribute(nextE);
	// String str = String.format(" Gröhl! %s: %S/%S: {%s}; ", rule.getName(),
	// element.toString(), nextE.toString(), attribute.toString());
	// System.out.print(str);
	// System.out.printf("NIX Font %s: %S/%S: {%s}; ", rule.getName(),
	// element.toString(),
	// nextE.toString(), attribute.toString());
	// System.out.print("(count: " + rule.getAttributeCount() + ")");

	/**
	 * Die Methode sucht aus den Fontnamen im {@link StyleSheet} den ersten heraus,
	 * der auch auf dem System installiert ist.
	 * 
	 * @param installierte ein {@link String}-Array der Namen installierter Fonts
	 * 
	 * @return einen {@link String} mit dem gefundenen Namen
	 */
	private String pickeFontName(String fonts, String[] installierte) {
		String[] einzelne = fonts.split(",\\s+");
		for (String einzelner : einzelne)
			for (String installierter : installierte)
				if (installierter.equals(einzelner))
					return einzelner;
		// sonst: Standard-Font zurückgeben
		return baseFont().getFontName();
	}

	/**
	 * Die Methode setzt die System-Standard-Schriftart für {@link JLabel}s aus den
	 * {@link UIDefaults} als {@link StyleConstants}.
	 * 
	 * @param sheet ein {@link StyleSheet}
	 * @url https://stackoverflow.com/questions/37851584/modifying-previously-set-css-style-of-jeditorpane
	 */
	private void applySystemConstants(StyleSheet sheet) {
		Font font = baseFont();
		// final float spacing = 1.35F;
		Style body = sheet.getStyle("body");
		StyleConstants.setFontSize(body, (int) (font.getSize() * FontHelfer.zoom));// 16);
		StyleConstants.setFontFamily(body, font.getFontName());// "Helvetica");
		// StyleConstants.setLineSpacing(body, spacing);
	}

	/**
	 * Die Methode ermittelt über den {@link UIManager} den Standard-Font
	 * 
	 * @return den ermittelten {@link Font}
	 */
	private Font baseFont() {
		final UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
		Font font = uid.getFont("Label.font");
		return font;
	}

	/*
	 * Die Methode dient dazu, eine HTML-Datei aus den Resources einzulesen.
	 * 
	 * @param name den Namen der HTML-Datei in den {@link
	 * ClassLoader#getResourceAsStream(String) Resources}.
	 * 
	 * @param doc public void htmlLesen(String name, StyledDocument doc,
	 * HTMLEditorKit kit) { InputStream is; try { is =
	 * getClass().getClassLoader().getResourceAsStream(name); doc.remove(0,
	 * doc.getLength()); doc.putProperty("IgnoreCharsetDirective", new
	 * Boolean(true)); kit.read(is, doc, 0); } catch (FileNotFoundException e) { new
	 * FehlerDialog(FehlerDialog.FEHLER_BLANKO, e.getLocalizedMessage(),
	 * e).showDialog(); } catch (IOException e) { new
	 * FehlerDialog(FehlerDialog.FEHLER_BLANKO, e.getLocalizedMessage(),
	 * e).showDialog(); } catch (BadLocationException e) { new
	 * FehlerDialog(FehlerDialog.FEHLER_BLANKO, e.getLocalizedMessage(),
	 * e).showDialog(); } }
	 */
}

// HTMLEditorKit kit = new HTMLEditorKit();
// HTMLEditorKit kit = (HTMLEditorKit) textPane.getEditorKit();
// , kit
// textPane.setEditorKit(kit);
// StyledDocument doc = (StyledDocument) kit.createDefaultDocument();
// textPane.setStyledDocument(doc);
// kit
// leseCss(cssfilename, kit);, kit

// , HTMLEditorKit kit
/*
 * @param kit das {@link HTMLEditorKit} des JTextPanes, das gefüllt werden soll.
 */
