/**
 * LadeSkktx.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.model.beschriftungen.Beschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.BerechnungFileChooser;
import eu.gronos.kostenrechner.view.KostenFileChooser;

/**
 * Die {@link Action} ruft einen {@link BerechnungFileChooser} auf. Der lädt die
 * Daten aller Registerkarten aus einer früher gespeicherten Berechnung (Strg+O)
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class LadeSkktxAction extends BeschriebeneAktion implements AbfrageLieferant {
	private static final long serialVersionUID = -2225698692818848010L;
	private JFrame frame;
	private BerechnungFileChooser fileChooser;

	/**
	 * Konstruktor.
	 * 
	 * @param frame          ein {@link JFrame}, z.B. {@link Kostenrechner}
	 * @param mnemonic       {@link Action#MNEMONIC_KEY}
	 * @param acceleratorKey {@link Action#ACCELERATOR_KEY}
	 */
	public LadeSkktxAction(JFrame frame, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.frame = frame;
	}
	// String name, String shortDescription, String actionCommandKey,, int mnemonic,
	// KeyStroke acceleratorKey
	// name, shortDescription, actionCommandKey,, mnemonic, acceleratorKey

	@Override
	public void actionPerformed(ActionEvent ae) {
		fileChooser = new BerechnungFileChooser((Beschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(75000));
		final VerfahrensDatenContainer container = fileChooser.ladeXmlDialog(this.frame);// menu.getKostenrechner()
		fileChooser = null;
		if (container != null)
			new XmlTransferHandler().setzeAlleWerteAusContainer(container);
	}// new VerfahrensDatenContainer2GUI().

	/**
	 * Die Methode leitet die Abfrage auf den {@link BerechnungFileChooser} um.
	 * 
	 * @return den {@link KostenFileChooser#getDialog()}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public JDialog getDialog() {
		if (fileChooser != null) {
			return fileChooser.getDialog();
		}
		return null;
	}
}