/**
 * TenorZwischenablageAction.java
 * eu.gronos.kostenrechner.view.result (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.result.TenorDialog;

/**
 * {@link Action} zum Kopieren des Tenors in die Zwischenablage
 *
 * @author Peter Schuster (setrok)
 * @date 22 Nov 2018
 *
 */
public class RtfZwischenablageAction extends BeschriebeneAktion {
	private final TenorDialog dialog;
	private static final long serialVersionUID = -1470041456809868231L;

	/**
	 * Konstruktor.
	 * 
	 * @param dialog       Verweis auf {@link TenorDialog}
	 * @param beschriftung eine {@link LangBeschriftung} mit
	 *                     {@link Action#MNEMONIC_KEY} und
	 *                     {@link Action#ACCELERATOR_KEY}
	 */
	public RtfZwischenablageAction(TenorDialog dialog, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.dialog = dialog;
	}
	// String name, String shortDescription, String actionCommandKey, , int
	// mnemonic,KeyStroke acceleratorKey
	// name, shortDescription, actionCommandKey, , mnemonic, acceleratorKey

	@Override
	public void actionPerformed(ActionEvent e) {
		dialog.getKit().kopiereRtfInZwischenablage();
	}
}