/**
 * SpeichereTenorAction.java
 * eu.gronos.kostenrechner.view.result (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.Action;
import javax.swing.JDialog;
import javax.xml.bind.JAXBException;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.system.BooleanConfigOptionHorcher;
import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.interfaces.AbfrageLieferant;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.view.KostenFileChooser;
import eu.gronos.kostenrechner.view.result.TenorDialog;

/**
 * Die {@link Action} speichert den Tenortext im Rich Text Format (RTF) über
 * {@link RtfDocHelper#speichereRTF()}.
 * 
 * Der {@link TenorDialog} fragt über {@link BooleanConfigOptionHorcher} ab, ob
 * er mit {@link TenorXmlDatei} auch den {@link TenorDatenContainer} speichern
 * soll.
 *
 * @author Peter Schuster (setrok)
 * @date 22 Nov 2018
 *
 */
public class SpeichereRtfAction extends BeschriebeneAktion implements AbfrageLieferant {
	private final TenorDialog tenorDialog;
	private TenorDatenContainer container;
	private static final long serialVersionUID = 1162624762983290295L;

	/**
	 * Konstruktor.
	 * 
	 * @param tenorDialog      Verweis auf {@link TenorDialog}
	 * @param container        ein {@link TenorDatenContainer}
	 * @param name             {@link Action#NAME}
	 * @param shortDescription {@link Action#SHORT_DESCRIPTION}
	 * @param mnemonic         {@link Action#MNEMONIC_KEY}
	 * @param actionCommandKey {@link Action#ACTION_COMMAND_KEY}
	 * @param acceleratorKey   {@link Action#ACCELERATOR_KEY}
	 */
	public SpeichereRtfAction(TenorDialog tenorDialog, TenorDatenContainer container, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.tenorDialog = tenorDialog;
		this.container = container;
	}
	// ,int mnemonic, KeyStroke acceleratorKey, mnemonic, acceleratorKey
	// String name,String shortDescription, String actionCommandKey,
	// name, shortDescription, actionCommandKey,

	@Override
	public void actionPerformed(ActionEvent e) {
		File datei = tenorDialog.getKit().speichereRTF(tenorDialog);
		if (datei != null && tenorDialog.isXmlSelected()) {
			datei = new File(datei.getAbsoluteFile() + TenorXmlDatei.DATEI_FILTER.ganzeEndung());
			// TenorXmlDatei.DATEIENDUNG_GANZ
			try {
				new TenorXmlDatei().speicherXml(container, datei);
			} catch (JAXBException je) {
				FehlerHelper.zeigeFehler("Fehler beim Umwandeln in XML", je);
			}
		}
	}// this.

	/**
	 * Die Methode leitet die Abfrage auf den {@link KostenFileChooser} um.
	 * 
	 * @return den {@link KostenFileChooser#getDialog()}, nicht etwa
	 *         {@link #tenorDialog}.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.AbfrageLieferant#getDialog()
	 */
	@Override
	public JDialog getDialog() {
		if (tenorDialog.getKit().getFileChooser() != null) {
			return tenorDialog.getKit().getFileChooser().getDialog();
		}
		return null;
	}
}