/*
 * FehlerAdapter.java
 * eu.gronos.kostenrechnertest.guitest.ausgaben (Kostenrechner Test)
 */
package eu.gronos.kostenrechner.controller.files;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * Die Klasse hilft beim Xml-Export eines {@link StackTraceElement}s
 *
 * @author Peter Schuster (setrok)
 * @date 27.11.2019
 *
 */
public class StackTraceAdapter extends XmlAdapter<StackTraceWrapper, StackTraceElement> {

	@Override
	public StackTraceWrapper marshal(StackTraceElement element) throws Exception {
		StackTraceWrapper wrap = new StackTraceWrapper();
		wrap.setClassName(element.getClassName());
		wrap.setFileName(element.getFileName());
		wrap.setLineNumber(element.getLineNumber());
		wrap.setMethodName(element.getMethodName());
		return wrap;
	}

	@Override
	public StackTraceElement unmarshal(StackTraceWrapper wrap) throws Exception {
		return new StackTraceElement(wrap.getClassName(), wrap.getMethodName(), wrap.getFileName(),
				wrap.getLineNumber());
	}

}
