/**
 * TenorXmlDatei.java
 * eu.gronos.kostenrechner.controller.files (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.files;

import java.io.File;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * Klasse zum Speichern des {@link TenorDatenContainer}s als XML.
 *
 * @author Peter Schuster (setrok)
 * @date 1 Jan 2019
 *
 */
public class TenorXmlDatei extends BerechnungXmlDatei {
	private static final String FEHLER_BEIM_KONVERTIEREN_IN_XML = "Programmzustände konnten nicht in XML konvertiert werden: ";
	private static final String SCHEMA_LOCATION = "https://www.kostentenor.de schema-tenordaten.xsd";

	@Override
	public String toXmlString(VerfahrensDatenContainer container) {
		if (!(container instanceof TenorDatenContainer))
			return super.toXmlString(container);

		StringWriter sw = new StringWriter();
		try {
			/* für den XML-String sollen keine Zeilenumbrüche erstellt werden */
			Marshaller marshaller = createMarshaller(false, getSchemaLocation());
			marshaller.marshal(container, sw);
		} catch (JAXBException e) {
			e.printStackTrace();
			return FEHLER_BEIM_KONVERTIEREN_IN_XML + e.getLocalizedMessage();
		}
		return sw.toString();
	}

	@Override
	public void speicherXml(VerfahrensDatenContainer container, File datei) throws JAXBException {
		if (!(container instanceof TenorDatenContainer))
			super.speicherXml(container, datei);

		Marshaller marshaller = createMarshaller(true, getSchemaLocation());
		marshaller.marshal(container, datei);
	}

	@Override
	public String getDateiendung() {
		return DATEIENDUNG;
	}

	/**
	 * 
	 * @see eu.gronos.kostenrechner.controller.files.XmlDatei#getSchemaLocation()
	 */
	@Override
	public String getSchemaLocation() {
		return SCHEMA_LOCATION;
	}

	/**
	 * Die Methode erstellt einen {@link Marshaller}, der dann zum Speichern als
	 * XML-Datei benötigt wird.
	 * 
	 * @param formattedOutput schaltet, ob der Marshaller Zeilenumbrüche und
	 *                        Einrückungen bauen soll
	 *                        {@link Marshaller#JAXB_FORMATTED_OUTPUT}
	 * @param schemaLocation  TODO
	 * @return einen {@link Marshaller}
	 * @throws JAXBException
	 * @throws PropertyException
	 */
	private static Marshaller createMarshaller(boolean formattedOutput, String schemaLocation)
			throws JAXBException, PropertyException {
		JAXBContext context = JAXBContext.newInstance(TenorDatenContainer.class);
		Marshaller marshaller = context.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, new Boolean(formattedOutput));
		marshaller.setProperty(Marshaller.JAXB_SCHEMA_LOCATION, schemaLocation);
		return marshaller;
	}

}
/* XmlDatei<TenorDatenContainer> */
// public static final String DATEIENDUNG = "schstdx";
// public static final String DATEIENDUNG_GANZ = "." + DATEIENDUNG;
// public static final String DATEITYP = "Schusters strukturierte Tenordaten
// XML-Dateien";
// getSchemaLocation()