/*
 * ThrowableWrapper.java
 * eu.gronos.kostenrechnertest.guitest.ausgaben (Kostenrechner Test)
 */
package eu.gronos.kostenrechner.controller.files;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * Die Klasse hilft beim Xml-Export eines {@link Throwable}s
 *
 * @author Peter Schuster (setrok)
 * @date 05.12.2019
 *
 */
@XmlRootElement(name = "error")
public class ThrowableWrapper {

	private String message;
	private String localizedMessage;
	private StackTraceElement[] stackTrace;
	private Throwable[] suppressed;
	private Throwable cause;

	public ThrowableWrapper() {
		super();
	}

	public ThrowableWrapper(Throwable error) {
		this();
		if (error != null) {
			if (error.getMessage() != null && error.getMessage().length() > "Exception".length())
				setMessage(error.getMessage());
			else
				setMessage(error.getClass().toString());
			setLocalizedMessage(error.getLocalizedMessage());
			setStackTrace(error.getStackTrace());
		} else {
			setMessage(null);
			setLocalizedMessage(null);
			setStackTrace(null);
		}
	}

	@XmlAttribute(name = "message")
	public String getMessage() {
		return this.message;

	}

	/**
	 * @param message d. {@link #message}, d. gesetzt werden soll als
	 *                {@link String}.
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return gibt die {@link Throwable#getLocalizedMessage()} als {@link String}
	 *         zurück.
	 */
	@XmlAttribute(name = "localized")
	public String getLocalizedMessage() {
		return this.localizedMessage;
	}

	public void setLocalizedMessage(String localizedMessage) {
		this.localizedMessage = localizedMessage;
	}

	/**
	 * 
	 * @return gibt den {@link Throwable#getStackTrace()} als Array von
	 *         {@link StackTraceElement}s zurück.
	 */
	@XmlElementWrapper(name = "trace")
	@XmlElement(name = "element")
	@XmlJavaTypeAdapter(StackTraceAdapter.class)
	public StackTraceElement[] getStackTrace() {
		return this.stackTrace;
	}

	/**
	 * @param stackTrace d. {@link #stackTrace}, d. gesetzt werden soll als
	 *                   {@link StackTraceElement[]}.
	 */
	public void setStackTrace(StackTraceElement[] stackTrace) {
		this.stackTrace = stackTrace;
	}

	/**
	 * @return gibt den {@link Throwable[]} {@link #suppressed} als {@link List} aus
	 *         {@link String}s zurück, also {@link Throwable#getSuppressed()}.
	 */
	@XmlElementWrapper(name = "hintergrund")
	@XmlElement(name = "suppressed")
	public List<String> getSuppressed() {
		if (suppressed == null)
			return null;
		List<String> list = new ArrayList<String>();
		for (Throwable sup : suppressed) {
			list.add(sup.toString());
		}
		return list;
	}

	/**
	 * @param suppressed d. {@link #suppressed}, d. gesetzt werden soll als
	 *                   {@link Throwable[]}.
	 */
	public void setSuppressed(Throwable[] suppressed) {
		this.suppressed = suppressed;
	}

	/**
	 * @return gibt den {@link Throwable} {@link #cause} als {@link String} zurück,
	 *         also {@link Throwable#getCause()}
	 */
	@XmlElement(name = "cause")
	public String getCause() {
		if (cause == null)
			return null;
		else
			return cause.toString();
	}

	/**
	 * @param cause d. {@link #cause}, d. gesetzt werden soll als {@link Throwable}.
	 */
	public void setCause(Throwable cause) {
		this.cause = cause;
	}

}