package eu.gronos.kostenrechner.controller.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.Deflater;

import javax.xml.bind.JAXBException;

import eu.gronos.kostenrechner.controller.system.FehlerHelper;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;

/**
 * Soll XML-Strings wie in {@link XmlDatei#toXmlString(Object)} komprimieren
 * 
 * TODO Einbauen!
 *
 * @author Peter Schuster (setrok)
 * @date 24 Jan 2019
 *
 */
public class ZipContainerXmlStrings {
	final VerfahrensDatenContainer verfahren;
	final TenorDatenContainer tenor;
	final Deflater compresser;

	/**
	 * 
	 * @param verfahrensDatenContainer ein {@link VerfahrensDatenContainer}
	 * @param tenorDatenContainer      ein {@link TenorDatenContainer}
	 */
	public ZipContainerXmlStrings(VerfahrensDatenContainer verfahrensDatenContainer,
			TenorDatenContainer tenorDatenContainer) {
		super();
		this.verfahren = verfahrensDatenContainer;
		this.tenor = tenorDatenContainer;
		compresser = new Deflater(Deflater.BEST_COMPRESSION);
	}

	/**
	 * Die Methode baut mit {@link Deflater#deflate(byte[])} aus
	 * {@link BerechnungXmlDatei#toXmlString(VerfahrensDatenContainer)} und
	 * {@link TenorXmlDatei#toXmlString(TenorDatenContainer)} ZIP-komprimierte
	 * Daten.
	 * 
	 * @return ein Array byte[]
	 */
	public byte[] zippedBytes() {
		BerechnungXmlDatei vdcXml = new BerechnungXmlDatei();
		TenorXmlDatei tdcXml = new TenorXmlDatei();
		String xmlString = vdcXml.toXmlString(verfahren) + "\n" + tdcXml.toXmlString(tenor);
		compresser.setInput(xmlString.getBytes());
		compresser.finish();
		byte[] output = new byte[compresser.getTotalOut()];
		compresser.deflate(output);
		return output;
	}

	/**
	 * Die Methode erstellt über {@link #speicherXml(Object, File)} eine temporäre
	 * Datei im Standard-Temp-Verzeichnis und gibt sie zurück.
	 * 
	 * @return
	 * @throws JAXBException
	 * @throws IOException
	 */
	public File speicherTempZip() throws IOException {
		final String suffix = "xmlzip";
		Path path = Files.createTempFile(null, suffix);
		File datei = path.toFile();
		speicherZip(datei);
		return datei;
	}

	/**
	 * Die Methode speichert die übergebenen ZIP-Daten als Datei.
	 * 
	 * @param file
	 */
	private boolean speicherZip(File file) {
		byte[] data = zippedBytes();
		try (FileOutputStream stream = new FileOutputStream(file)) {
			stream.write(data);
			stream.flush();
			return true;
		} catch (FileNotFoundException e) {
			FehlerHelper.zeigeFehler(
					"Fehler beim Speichern einer ZIP-Datei:\nDie ZIP-Datei konnte nicht gefunden werden", e);
			return false;
		} catch (IOException e) {
			FehlerHelper.zeigeFehler(String.format(
					"Fehler beim Speichern einer ZIP-Datei:%nDie ZIP-Datei konnte nicht gespeichert werden: %s",
					file.getAbsolutePath()), e);
			return false;
		}

	}
}
