/**
 * ForderungsStaffelungTenorAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.forderungen;

import javax.swing.Action;

import eu.gronos.kostenrechner.controller.TenorAction;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.logic.forderungen.AngriffsVerteidigungsmittelStaffelung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.forderungen.ForderungsStaffelungPanel;
import eu.gronos.kostenrechner.view.menus.ExtrasJMenu;

/**
 * Die AbstractAction ist eine {@link Action} zum Ermitteln des Tenors auf
 * Registerkarte Hilfsaufrechnung (3) über
 * {@link AngriffsVerteidigungsmittelStaffelung}
 * 
 * @author Peter Schuster (setrok)
 * @date 04.11.2018
 *
 */
public class ForderungsStaffelungTenorAction extends TenorAction {
	private final ForderungsStaffelungPanel panel;
	private static final long serialVersionUID = 2748367225462023438L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link ForderungsStaffelungPanel}
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 */
	public ForderungsStaffelungTenorAction(ForderungsStaffelungPanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}

	/**
	 * Die Methode prüft, ob alle nötigen Oberflächenelemente non-null sind
	 * 
	 * @return <code>true</code>, wenn {@link #alleWerte()} gefahrlos laufen kann.
	 * @throws IllegalArgumentException wird ansonsten geworfen (<code>false</code>
	 *                                  gibt es nicht), damit die {@link Exception}
	 *                                  direkt behandelt werden kann.
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#allesOk()
	 */
	@Override
	protected boolean allesOk() throws IllegalArgumentException {
		if (this.panel.cbAngriffsKlaeger == null || this.panel.cbVerteidigungsBeklagter == null
				|| this.panel.ftm == null || ExtrasJMenu.getInstance().mi92 == null) {
			throw new IllegalArgumentException(
					"Oberfläche in der Hilfsaufrechnung noch nicht ganz fertig initialisiert ...");
		} else {
			return true;
		}
	}

	/**
	 * Die Methode ruft {@link AngriffsVerteidigungsmittelStaffelung} auf.
	 * 
	 * @param container einen {@link VerfahrensDatenContainer}, den
	 *                  {@link TenorAction} über
	 *                  {@link XmlTransferHandler#leseAlleWertefuerContainer()}
	 *                  zusammenstellt
	 * @return den {@link TenorDatenContainer}
	 * @throws IllegalArgumentException wenn was schief läuft
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#tenorDaten(eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer)
	 */
	@Override
	protected TenorDatenContainer tenorDaten(VerfahrensDatenContainer container) throws IllegalArgumentException {
		return new AngriffsVerteidigungsmittelStaffelung(container).erzeugeContainer();
	}

}
//// String name, String shortDescription,, String actionCommandKey
//super(name, shortDescription, mnemonic, actionCommandKey);

// @Override
// public void actionPerformed(ActionEvent ae) {
// try {
// if (allesOk())
// ;
// final TenorDatenContainer tenorDaten = tenorDaten(alleWerte());
// showDialog(tenorDaten);
// } catch (IllegalArgumentException e) {
// FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
// }
// }
// setDialog(new TenorDialog(this.panel.getKostenrechner(),
// tenorDaten)).showDialog();
// setDialog(null);
// new VerfahrensDatenContainer2GUI().// .allgemein, container.staffelung,
// containercontainer
// final VerfahrensDatenContainer container = new
// XmlTransferHandler().leseAlleWertefuerContainer();
// final TenorDatenContainer tenorDaten =
// tenorDaten;