/**
 * TeilklageGebuehrVorherAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.controller.ComponentBeschrifter;
import eu.gronos.kostenrechner.interfaces.DialogLieferant;
import eu.gronos.kostenrechner.interfaces.PanelTableModelHandler;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainerSammlung;
import eu.gronos.kostenrechner.model.beschriftungen.VorsorgendeBeschriftung;
import eu.gronos.kostenrechner.model.gebuehren.AnwaltsGebuehrenTabelle;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTatbestand;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenVerzeichnis;
import eu.gronos.kostenrechner.model.gebuehren.GerichtsGebuehrenTabelle;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrHinzufuegenDialog;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Der AbstractAction mit dem Namen neueGebuehrVorher fügt einen neuen
 * Gebührentatbestand in die Tabelle der vor der Streitwertreduktion
 * entstandenen, in die Tabelle für die nach Gebühren ein, die nach der
 * Streitwertreduktion entstanden sind oder in die Tabelle für die Gebühren zur
 * freien Berechnung ein.
 * 
 * {@link KeyEvent#VK_N} und {@link KeyEvent#VK_R}
 *
 */
public class GebuehrNeuAction extends BeschriebeneAktion implements DialogLieferant {
	private final PanelTableModelHandler<GebuehrenTableModel> panel;
	private static final long serialVersionUID = 7170038539836176410L;
	private final int index;
	private /* final */ GebuehrenVerzeichnis alleTatbestaende;
	private GebuehrHinzufuegenDialog dialog = null;
	private final int gebuehrenKey;
	public static final int RVG_KEY = 32;
	public static final int GKG_KEY = 64;
	public static final int ALLE_KEY = RVG_KEY + GKG_KEY;

	/**
	 * Der Standardkonstruktor fordert auch ein {@link GebuehrenVerzeichnis} aller
	 * {@link GebuehrenTatbestand}e
	 * 
	 * @param panel        ein {@link PanelTableModelHandler}
	 * @param index        {@link TeilklageruecknahmePanel#TABLE_FTF_VORHER} oder
	 *                     {@link TeilklageruecknahmePanel#TABLE_FTF_NACHHER} oder
	 *                     {@link GebuehrenBerechnungPanel#TABLE_FTF_GEBUEHREN}
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 * @param mnemonic     ({@link javax.swing.Action#MNEMONIC_KEY}) The key used
	 *                     for storing an Integer that corresponds to one of the
	 *                     KeyEvent key codes. The value is commonly used to specify
	 *                     a mnemonic. KeyEvent.getExtendedKeyCodeForChar('\u0444'))
	 *                     sets the mnemonic of myAction to Cyrillic letter "Ef".
	 * @param gebuehrenKey
	 * 
	 */
	public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, LangBeschriftung beschriftung, int index,
			// GebuehrenVerzeichnis alleTatbestaende
			int gebuehrenKey) {
		super(beschriftung);
		this.panel = panel;
		this.index = index;
		this.gebuehrenKey = gebuehrenKey;
		// this.alleTatbestaende = alleTatbestaende;
	}
	// @param alleTatbestaende ein Array aller {@link GebuehrenTatbestand}e

	/**
	 * Der weitere Konstruktor nimmt einfach alle Gebührentatbestände
	 * 
	 * @param panel        ein {@link PanelTableModelHandler}
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),{@link javax.swing.Action#MNEMONIC_KEY},
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 * @param index        {@link TeilklageruecknahmePanel#TABLE_FTF_VORHER} oder
	 *                     {@link TeilklageruecknahmePanel#TABLE_FTF_NACHHER} oder
	 *                     {@link GebuehrenBerechnungPanel#TABLE_FTF_GEBUEHREN}
	 */
	public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, LangBeschriftung beschriftung,
			int index) {
		this(panel, beschriftung, index, ALLE_KEY);
		// createAlleGebuehrenTatbestaende());
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final String name = (String) getValue(Action.NAME);
		VorsorgendeBeschriftung vorsorgend = (VorsorgendeBeschriftung) NameContainerSammlung.BESCHRIFTUNGEN.get(16000);
		ComponentBeschrifter beschrifter = new ComponentBeschrifter();
		beschrifter.changeTo(vorsorgend, 0);
		beschrifter.changeTo(vorsorgend, name);
		GebuehrenTatbestand gt = setDialog(
				// alleTatbestaende
				new GebuehrHinzufuegenDialog(Kostenrechner.getInstance(), vorsorgend, getAlleTatbestaende()))
						.showDialogAndAsk();
		if (gt != null)
			panel.getTableModel(index).addRow(gt);
		setDialog(null);
	}
	// panel.getKostenrechner(),
	// if (vorsorgend.getAlternativeTitles().contains(name))
	// vorsorgend.changeTo(vorsorgend.getAlternativeTitles().indexOf(name));
	// else
	// System.out.println("Schade!");

	/**
	 * 
	 * @return
	 * @return gibt den {@link GebuehrHinzufuegenDialog} zurück, den die Aktion
	 *         erstellt.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.DialogLieferant#getDialog()
	 */
	@Override
	public GebuehrHinzufuegenDialog getDialog() {
		// System.out.println("Gesetzt!");
		return dialog;
	}

	/**
	 * @return gibt {@link #alleTatbestaende} als {@link GebuehrenVerzeichnis}
	 *         zurück.
	 */
	private GebuehrenVerzeichnis getAlleTatbestaende() {
		if (alleTatbestaende == null) {
			if (RVG_KEY == gebuehrenKey)
				alleTatbestaende = GebuehrenGesetzesSammlung.getRvg().getVerzeichnis();
			else if (GKG_KEY == gebuehrenKey)
				alleTatbestaende = GebuehrenGesetzesSammlung.getGkg().getVerzeichnis();
			else
				alleTatbestaende = createAlleGebuehrenTatbestaende();
		}
		return alleTatbestaende;
	}

	private GebuehrHinzufuegenDialog setDialog(GebuehrHinzufuegenDialog dialog) {
		this.dialog = dialog;
		return dialog;
	}

	/**
	 * Die Methode dient dazu, alle {@link GebuehrenTatbestand}e für
	 * {@link GebuehrHinzufuegenDialog} zusammenzustellen, falls keine dem
	 * Konstruktor übergeben wurden.
	 * 
	 * @return die {@link GebuehrenTatbestand}e der {@link GerichtsGebuehrenTabelle}
	 *         und der {@link AnwaltsGebuehrenTabelle} als Array
	 */
	private static GebuehrenVerzeichnis createAlleGebuehrenTatbestaende() {
		GebuehrenVerzeichnis verzeichnis = new GebuehrenVerzeichnis();
		verzeichnis.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis());
		verzeichnis.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis());
		return verzeichnis;
	}
}
/* GebuehrenTatbestand[] */ /* GebuehrenTatbestand[] */
//	@Deprecated
//	public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, String name, String shortDescription,
//			int mnemonic, String actionCommandKey, int index, GebuehrenVerzeichnis alleTatbestaende) {
//		super(name, shortDescription, mnemonic, actionCommandKey);
//		this.panel = panel;
//		this.index = index;
//		this.alleTatbestaende = alleTatbestaende;
//	}
/* GebuehrenTatbestand[] */
//	super(beschriftung, mnemonic);int mnemonic,  mnemonic, KeyEvent.VK_N, KeyEvent.VK_R, KeyEvent.VK_V, KeyEvent.VK_N, 
//	this.panel = panel;
//	this.index = index;
//	this.alleTatbestaende =

//	@Deprecated
//	public GebuehrNeuAction(PanelTableModelHandler<GebuehrenTableModel> panel, String name, String shortDescription,
//			int mnemonic, String actionCommandKey, int index) {
//		this(panel, name, shortDescription, mnemonic, actionCommandKey, index, createAlleGebuehrenTatbestaende());
//	}
// int mnemonic, , mnemonic
// (new KostenVerzeichnis());
// (new VerguetungsVerzeichnis());
//		return GebuehrenTabelle.mergeAllGebuehrenTatbestaende(KostenVerzeichnis.getAllGebuehrenTatbestaende(),
//				VerguetungsVerzeichnis.getAllGebuehrenTatbestaende());