/**
 * GebuehrenDragListener.java
 * eu.gronos.kostenrechner.controller.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

import eu.gronos.kostenrechner.controller.AllzweckHorcher;

/**
 * Der AllzweckHorcher mit dem Namen DRAG_HORCHER markiert beim Drag'n'Drop die
 * Zeile über der sich der Mauszeiger befindet und stößt dann
 * {@link javax.swing.TransferHandler#exportAsDrag(JComponent, InputEvent, int)
 * exportAsDrag} an.
 * 
 * @see "http://stackoverflow.com/questions/638807/how-do-i-drag-and-drop-a-row-in-a-jtable"
 *      How do I drag and drop a row in a JTable?
 *
 * @author Peter Schuster (setrok)
 * @date 20 Dec 2018
 *
 */
public class GebuehrenDragListener extends AllzweckHorcher
		/*implements DragSourceListener, DragGestureListener, DropTargetListener*/  {

	// TODO DragListener

	@Override
	public void mouseDragged(MouseEvent me) {
		me.consume();
		JTable table = (JTable) me.getSource();
		int row = table.rowAtPoint(me.getPoint());
		if (row > -1) {
			table.changeSelection(row, -1, false, false);
			TransferHandler handler = table.getTransferHandler();
			handler.exportAsDrag(table, me, TransferHandler.MOVE);
		} else {
			System.out.println("mouseDragged(MouseEvent me): keine Zeile markiert/markierbar.");
		}
	}

}