/**
 * TeilklageTenorAction.java
 * eu.gronos.kostenrechner.controller.gebuehren (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import eu.gronos.kostenrechner.controller.TenorAction;
import eu.gronos.kostenrechner.controller.files.XmlTransferHandler;
import eu.gronos.kostenrechner.logic.gebuehren.MehrkostenMethode;
import eu.gronos.kostenrechner.logic.gebuehren.QuotenMethode;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Der {@link TenorAction} erzeugt den Kostentenor wahlweise nach der
 * Quotenmethode oder nach der Mehrkostenmethode.
 *
 * @author Peter Schuster (setrok)
 * @date 18 Feb 2019
 *
 */
public class TeilklageTenorAction extends TenorAction {
	private static final long serialVersionUID = -172361077062445138L;
	private final TeilklageruecknahmePanel panel;

	public TeilklageTenorAction(TeilklageruecknahmePanel teilklageruecknahmePanel, LangBeschriftung beschriftung) {
		super(beschriftung);
		panel = teilklageruecknahmePanel;
	}

	/**
	 * Die Methode prüft, ob alle nötigen Oberflächenelemente non-null sind, hier
	 * vor allem die Gebühren
	 * 
	 * @return <code>true</code>, wenn {@link #alleWerte()} gefahrlos laufen kann.
	 * @throws IllegalArgumentException wird ansonsten geworfen (<code>false</code>
	 *                                  gibt es nicht), damit die {@link Exception}
	 *                                  direkt behandelt werden kann.
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#allesOk()
	 */
	@Override
	protected boolean allesOk() throws IllegalArgumentException {
		if (!panel.pruefeTabellen()) {
			throw new IllegalArgumentException(TeilklageruecknahmePanel.FEHLER_KEINE_GEBUEHREN_LANG);
		}
		return true;
	}

	/**
	 * Die Methode ruft {@link QuotenMethode} oder {@link MehrkostenMethode} auf.
	 * 
	 * @param container einen {@link VerfahrensDatenContainer}, den
	 *                  {@link TenorAction} über
	 *                  {@link XmlTransferHandler#leseAlleWertefuerContainer()}
	 *                  zusammenstellt
	 * @return den {@link TenorDatenContainer}
	 * @throws IllegalArgumentException wenn was schief läuft
	 * 
	 * @see eu.gronos.kostenrechner.controller.TenorAction#tenorDaten(eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer)
	 */
	@Override
	protected TenorDatenContainer tenorDaten(VerfahrensDatenContainer container) throws IllegalArgumentException {
		if (panel.isQuotenMethodeVorziehen()) {
			return new QuotenMethode(container).erzeugeContainer();
		} else {
			return new MehrkostenMethode(container).erzeugeContainer();
		}
	}
}
// String name, String shortDescription,, String actionCommandKey,int
// mnemonic,KeyEvent.VK_Q,
// super(name, shortDescription, mnemonic, actionCommandKey);

// @Override
// public void actionPerformed(ActionEvent ae) {
//// tenorDaten;
// try {
// allesOk();
// TenorDatenContainer tenorDaten = tenorDaten(alleWerte());
// showDialog(tenorDaten);
// } catch (IllegalArgumentException e) {
// FehlerHelper.zeigeFehler(e.getLocalizedMessage(), e);
// }
// }
// .allgemein, container.teilklageruecknahme)// .allgemein,
// container.teilklageruecknahme), container
// new VerfahrensDatenContainer2GUI()verfahrensDatenverfahrensDaten
// final VerfahrensDatenContainer verfahrensDaten = new
// XmlTransferHandler().leseAlleWertefuerContainer();
// setDialog(new TenorDialog(panel.getKostenrechner(),
// tenorDaten)).showDialog();
// setDialog(null);
// panel.fehlerKeineGebuehren();
// TenorDatenContainer tenorDaten;
// tenorDaten =
// tenorDaten =
// tenorDaten;
