/**
 * TeiklageRuecknahmeTerminAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.GebuehrenTableTextfieldHandler;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenGesetzesSammlung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die {@link Action} leert die Tabelle mit den Gebührentatbeständen und füllt
 * sie mit der Konstellation Teilklagerücknahme vor Anfall der Terminsgebühr.
 * {@link KeyEvent#VK_F}
 */
public class TeilklageTerminAction extends BeschriebeneAktion {
	private final GebuehrenTableTextfieldHandler handler;
	private static final long serialVersionUID = -7826777167427931422L;

	/**
	 * Konstruktor.
	 * 
	 * @param handler      Verweis auf {@link TeilklageruecknahmePanel}
	 * @param beschriftung eine Lang{@link LangBeschriftung}, auch mit
	 *                     {@link Action#MNEMONIC_KEY}
	 */
	public TeilklageTerminAction(GebuehrenTableTextfieldHandler handler, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.handler = handler;
	}
	// String name, String shortDescription,, String actionCommandKey, int mnemonic, KeyEvent.VK_F
	// super(name, shortDescription, mnemonic, actionCommandKey, mnemonic);

	/**
	 * Die Methode füllt die Tabellen mit den Tatbeständen zum Standardfall, wenn
	 * mit den Tatbeständen zum Standardfall gefüllt werden sollen.
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		GebuehrenTableModel gttm = handler.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_VORHER);

		gttm.clear();
		gttm.addAll(GebuehrenGesetzesSammlung.getGkg().getVerzeichnis().getAll("1210 KV"));
		gttm.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3100 VV", "3100 VV"));

		gttm = handler.getTableModel(TeilklageruecknahmePanel.TABLE_FTF_NACHHER);
		gttm.clear();
		gttm.addAll(GebuehrenGesetzesSammlung.getRvg().getVerzeichnis().getAll("3104 VV", "3104 VV"));

		handler.requestFocusInWindow();
	}

	// boolean mitInhalt
//			if (mitInhalt) {
//				setGttmVorher(new GebuehrenTatbestandTableModel(new ArrayList<GebuehrenTatbestand>(
//						Arrays.asList(new GebuehrenSatzTatbestand[] { GerichtsGebuehrenTabelle.KV1210,
//								AnwaltsGebuehrenTabelle.VV3100, AnwaltsGebuehrenTabelle.VV3100 }))));
//				setGttmNachher(new GebuehrenTatbestandTableModel(
//						new ArrayList<GebuehrenTatbestand>(Arrays.asList(new GebuehrenSatzTatbestand[] {
//								AnwaltsGebuehrenTabelle.VV3104, AnwaltsGebuehrenTabelle.VV3104 }))));
//			} else {
//			}
//		Kostenrechner.getInstance().getTabbedPane().setSelectedIndex(0);
}