/**
 * TeilklageRuecknahmeVerschiebenAction.java
 * eu.gronos.kostenrechner.view.panel (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.gebuehren;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Die {@link Action} entfernt den markierten Eintrag aus dieser Tabelle und
 * fügt ihn der jeweils anderen hinzu. Soll ins Kontextmenü.
 * {@link KeyEvent#VK_T}
 *
 */
public class TeilklageVerschiebenAction extends BeschriebeneAktion {
	private final TeilklageruecknahmePanel panel;
	private static final long serialVersionUID = 2748367225462023438L;

	/**
	 * Konstruktor.
	 * 
	 * @param panel        Verweis auf {@link TeilklageruecknahmePanel}
	 * @param beschriftung die {@link LangBeschriftung}, auch mit
	 *                     {@link Action#MNEMONIC_KEY}
	 */
	public TeilklageVerschiebenAction(TeilklageruecknahmePanel panel, LangBeschriftung beschriftung) {
		super(beschriftung);
		this.panel = panel;
	}
//	public TeilklageVerschiebenAction(TeilklageruecknahmePanel panel, String name, String shortDescription,
//			int mnemonic, int mnemonic, String actionCommandKey) {, KeyEvent.VK_T
//		super(name, shortDescription, mnemonic, mnemonic, actionCommandKey);
//		this.panel = panel;
//	}

	@Override
	public void actionPerformed(ActionEvent ae) {
		Object o = ae.getSource();
		if (!(o instanceof JMenuItem)) {
			return;
		}
		if (panel.tabVorher == null || panel.tabNachher == null
				|| !(panel.tabVorher.getModel() instanceof GebuehrenTableModel)
				|| !(panel.tabNachher.getModel() instanceof GebuehrenTableModel))
			return;
		// Herausfinden, welche Tabelle ruft
		JPopupMenu popup = (JPopupMenu) ((JMenuItem) o).getParent();
		if (popup.getName().equals("17100"))// popup.getLabel() == TeilklageruecknahmePanel.VORHER_POPUPLABEL)
			verschiebeGebuehrenTatbestand((GebuehrenTableModel) panel.tabVorher.getModel(),
					(GebuehrenTableModel) panel.tabNachher.getModel(), panel.tabVorher.getSelectedRow());
		if (popup.getName().equals("17200"))// popup.getLabel() == TeilklageruecknahmePanel.NACHHER_POPUPLABEL
			verschiebeGebuehrenTatbestand((GebuehrenTableModel) panel.tabNachher.getModel(),
					(GebuehrenTableModel) panel.tabVorher.getModel(), panel.tabNachher.getSelectedRow());
	}

	/**
	 * Die Methode verschiebt einen Gebührentatbestand aus einer JTable in die
	 * andere.
	 * 
	 * @todo TODO Dann UnitTests!
	 * 
	 * @param ausgang     das {@link GebuehrenTableModel}, aus der die Zeile
	 *                    gelöscht werden soll
	 * @param ziel        das {@link GebuehrenTableModel}, in die die Zeile
	 *                    verschoben werden soll
	 * @param selectedRow {@link JTable#getSelectedRow()} der Ausgangstabelle
	 */
	private void verschiebeGebuehrenTatbestand(GebuehrenTableModel ausgang, GebuehrenTableModel ziel, int selectedRow) {
		if (ausgang == null || ziel == null || selectedRow < 0)
			return;
		ziel.addRow(ausgang.getRow(selectedRow));
		ausgang.removeRow(selectedRow);
	}

	/*
	 * GebuehrenTatbestandTableModel if (ausgang == null || ziel == null ||
	 * ausgang.getSelectedRow() < 0 || !(ausgang.getModel() instanceof
	 * GebuehrenTatbestandTableModel) || !(ziel.getModel() instanceof
	 * GebuehrenTatbestandTableModel)) return; GebuehrenTatbestandTableModel
	 * ausgangsModel = (GebuehrenTatbestandTableModel) ausgang.getModel();
	 * GebuehrenTatbestandTableModel zielModel = (GebuehrenTatbestandTableModel)
	 * ziel.getModel(); int selectedRow = ausgang.getSelectedRow();
	 */
}