/*
 * DatenschutzAblehnungAktion.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;

/**
 *
 * Nein-Button für {@link DatenschutzZustimmungDialog}
 *
 * @author Peter Schuster (setrok)
 * @date 11.01.2020
 *
 */
public class DatenschutzAblehnungAktion extends BeschriebeneAktion {
	private static final long serialVersionUID = -1550757514414058462L;
	private DatenschutzZustimmungDialog dialog;
	DatenschutzZustimmungAktion pruefer;

	/**
	 * Konstruktor mit den nötigen Feldern.
	 * 
	 * @param beschriftung eine {@link LangBeschriftung}
	 * @param dialog       der {@link DatenschutzZustimmungDialog}
	 * @param pruefer      die {@link DatenschutzAblehnungAktion} (dessen
	 *                     Prüferseele)
	 */
	public DatenschutzAblehnungAktion(LangBeschriftung beschriftung, DatenschutzZustimmungDialog dialog,
			DatenschutzZustimmungAktion pruefer) {
		super(beschriftung);
		this.dialog = dialog;
		this.pruefer = pruefer;
	}

	/**
	 * Die Methode setzt die {@link DatenschutzZustimmung} für das
	 * {@link DatenschutzZustimmungAktion#getAktuellesLevel()} auf
	 * <code>false</code> und beendet den Dialog.
	 * 
	 * @param e ein {@link ActionEvent}, aus dem nichts gezogen wird.
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		pruefer.getRueckgabewert().set(pruefer.getAktuellesLevel(), false);
		// setOk(true) mag seltsam erscheinen, aber
		// für das vorige Level muss es ja ein "Ja" gegeben haben.
		dialog.setOk(true);
		dialog.setVisible(false);
		dialog.dispose();
	}
}