/*
 * DatenschutzZustimmungAktion.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.SwingUtilities;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.ParsendUndBauend;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.helpanderror.DatenschutzZustimmungDialog;

/**
 * Die {@link BeschriebeneAktion} und {@link ParsendUndBauend} dient der
 * JA-Schaltfläche;
 * 
 * Sie setzt das OK-Field auf wahr und schließt das Fenster (wie der OK-Button)
 * oder: geht einen Zustand höher (wie Weiter)
 *
 * @author Peter Schuster (setrok)
 * @date 10.01.2020
 *
 */
public class DatenschutzZustimmungAktion extends BeschriebeneAktion implements ParsendUndBauend<DatenschutzZustimmung> {
	private static final long serialVersionUID = 3427160893867504969L;
	private DatenschutzZustimmungDialog dialog;
	private DatenschutzZustimmung rueckgabewert;
	private int benoetigtesLevel;
	private int aktuellesLevel;
	// private JTabbedPane tabbedPane;

	public DatenschutzZustimmungAktion(DatenschutzZustimmungDialog dialog, LangBeschriftung beschriftung, int level,
			DatenschutzZustimmung rueckgabewert) {
		super(beschriftung);
		this.dialog = dialog;
		this.rueckgabewert = rueckgabewert;
		this.benoetigtesLevel = level;
		if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS == level) {
			// Wenn nur Basis gebraucht
			setAktuellesLevel(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS);
		} else if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG == level) {
			// Wenn Anhang gebraucht, prüfen ob der Basis schon zugestimmt ist
			if (rueckgabewert.emailBasisZugestimmt) {
				setAktuellesLevel(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG);
			} else {
				setAktuellesLevel(DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS);
			}
		} else
			throw new IllegalArgumentException("level hat keinen gültigen Wert");
	}

	/**
	 * Die Methode wird bei Klick auf "Ja" aufgerufen
	 * 
	 * @param e ein {@link ActionEvent}
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
		parseEingabe();
		if (calculateIndex() == 0 && getAktuellesLevel() < getBenoetigtesLevel()) {
			// Wenn zweites Tab nötig und man noch auf Tab 1 ist: Zustand erhöhen und auf
			// zweites Tab wechseln
			setAktuellesLevel(getBenoetigtesLevel());
			SwingUtilities.invokeLater(() -> dialog.wechseleTab());
			return;
		} else {
			// Sonst Dialog schließen
			dialog.setOk(true);
			dialog.setVisible(false);
			dialog.dispose();
		}
	}

	public int calculateIndex() {
		if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS == getAktuellesLevel())
			return 0;
		else if (DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG == getAktuellesLevel())
			return 1;
		return -1;
	}

	/**
	 * Die Methode muss gar keine {@link Component}s lesen?
	 * 
	 * @param components
	 * @return dies hier
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#leseComponents(java.awt.Component[])
	 */
	@Override
	public ParsendUndBauend<DatenschutzZustimmung> leseComponents(Component... components) {
		// nix
		return this;
	}

	/**
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#parseEingabe()
	 */
	@Override
	public boolean parseEingabe() {
		try {
			rueckgabewert.set(getAktuellesLevel(), true);
			return parseEingabe(rueckgabewert);
		} catch (IllegalArgumentException | NullPointerException ne) {
			FehlerHelper.zeigeFehler(ne.getLocalizedMessage(), ne);
			return false;
		}
	}

	/**
	 * Methode zum Plausis checken, wird vom OK-Button aufgerufen.
	 * 
	 * @param rueckgabewert die {@link DatenschutzZustimmung}
	 * 
	 * @return true, wenn alle Plausis eingehalten werden
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#parseEingabe(java.lang.Object)
	 */
	@Override
	public boolean parseEingabe(DatenschutzZustimmung rueckgabewert)
			throws IllegalArgumentException, NullPointerException {
		this.rueckgabewert = rueckgabewert;
		return true;
	}

	/**
	 * Die Methode gibt einen Rückgabewert zurück, der aus den Eingabefeldern des
	 * Dialogs zusammengebaut wurde, der dann von {@link #showDialogAndAsk()} an die
	 * aufrufende Maske zurückgegeben werden kann.
	 * 
	 * @return eine {@link DatenschutzZustimmung}
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.ParsendUndBauend#getRueckgabewert()
	 */
	@Override
	public DatenschutzZustimmung getRueckgabewert() {
		return rueckgabewert;
	}

	/**
	 * @return gibt {@link #benoetigtesLevel} als {@link int} zurück.
	 */
	public int getBenoetigtesLevel() {
		return benoetigtesLevel;
	}

	/**
	 * @return gibt {@link #aktuellesLevel} als {@link int} zurück.
	 */
	public int getAktuellesLevel() {
		return aktuellesLevel;
	}

	/**
	 * @param aktuellesLevel d. {@link #aktuellesLevel}, d. gesetzt werden soll als
	 *                       {@link int}.
	 */
	public void setAktuellesLevel(int aktuellesLevel) {
		this.aktuellesLevel = aktuellesLevel;
	}

}