/*
 * InfoAction.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.interfaces.DialogLieferant;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.view.helpanderror.LizenzZustimmungDialog;

/**
 * Die Action ruft den Dialog hinter {@link InfoAction#ueberKostenrechner()}
 * auf, der Informationen über das Programm anzeigt. {@link KeyEvent#VK_U}
 * zusammengeführt mit dem Dialog mit der Kurzform der Lizenzbedingungen auf:
 *
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class InfoAction extends BeschriebeneAktion implements DialogLieferant {
	private static final long serialVersionUID = 8764673598010088506L;
	private LizenzZustimmungDialog dialog = null;

	/**
	 * Konstruktor.
	 * 
	 * @param beschriftung eine {@link LangBeschriftung}, der auch
	 *                     ({@link javax.swing.Action#NAME}),
	 *                     ({@link javax.swing.Action#SHORT_DESCRIPTION}),{@link Action#MNEMONIC_KEY},
	 *                     ({@link javax.swing.Action#ACTION_COMMAND_KEY}) entnommen
	 *                     werden.
	 */
	public InfoAction(LangBeschriftung beschriftung) {
		super(beschriftung);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		ueberKostenrechner();
	}


	/**
	 * Die Methode stellt eine einfache "Info über"-Meldung dar.
	 * 
	 */
	void ueberKostenrechner() {
		setDialog(new LizenzZustimmungDialog(Kostenrechner.getInstance(), false)).showDialogAndAsk();
		setDialog(null);
	}

	/**
	 * @return gibt {@link #dialog} als {@link LizenzZustimmungDialog} zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.DialogLieferant#getDialog()
	 */
	public LizenzZustimmungDialog getDialog() {
		return dialog;
	}

	/**
	 * @param dialog d. {@link #dialog}, d. gesetzt werden soll als
	 *               {@link LizenzZustimmungDialog}.
	 * @return
	 */
	public LizenzZustimmungDialog setDialog(LizenzZustimmungDialog dialog) {
		this.dialog = dialog;
		return dialog;
	}

}
