/**
 * CopyrightNoergler.java
 * eu.gronos.kostenrechner.controller.system (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import javax.swing.JFrame;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.interfaces.Noergelnd;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.model.beschriftungen.StringConfigSchluessel;
import eu.gronos.kostenrechner.view.helpanderror.LizenzZustimmungDialog;

/**
 * Wenn die Lizenzvereinbarung noch nicht akzeptiert wurde, dann nörgeln. Wenn
 * nicht akzeptiert wird, dann Programm beenden. Sonst Vermerk in
 * Registry/Preferences und Programmstart.
 *
 * @author Peter Schuster (setrok)
 * @date 21 Feb 2019
 *
 */
public class LizenzNoergler implements Noergelnd<LizenzConfigOption> {

	private final JFrame owner;
	private static final LizenzConfigOption option = new LizenzConfigOption(new StringConfigSchluessel("lizenz", ""));
	public static final int OPTION_LIZENZ = 13;

	/**
	 * @param owner ein {@link JFrame}
	 */
	public LizenzNoergler(JFrame owner) {
		this.owner = owner;
	}

	/**
	 * Wenn die Lizenzvereinbarung noch nicht akzeptiert wurde, dann nörgeln. Wenn
	 * nicht akzeptiert wird, dann Programm beenden. Sonst Vermerk in
	 * Registry/Preferences und Programmstart.
	 */
	public boolean noergle() {
		if (getOption().equalsRegistry(Kostenrechner.KOSTENRECHNER_VERSION)) {
			// Lizenz schon vorher akzeptiert: alles super!
			return true;
		} else {
			// Sonst Abfrage
			// Und: Bei einer neuen Version muss dem E-Mail-Versand auch nochmal zugestimmt werden.
			new DatenschutzNoergler(owner, DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS).reset();
			new DatenschutzNoergler(owner, DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG).reset();
			boolean akzeptiert = false;
			final Boolean wert = new LizenzZustimmungDialog(owner).showDialogAndAsk();
			if (wert != null)
				akzeptiert = wert.booleanValue();
			if (akzeptiert) {
				getOption().confirm(true);
				return true;
			} else {
				System.exit(1);
				return false;
			}
		}
		/*
		 * if (!getOption().equalsRegistry(Kostenrechner.KOSTENRECHNER_VERSION)) {
		 * boolean akzeptiert = new
		 * LizenzAkzeptanzHinzufuegen(owner).showDialog().booleanValue(); // ==
		 * Boolean.TRUE ? true : false; if (akzeptiert) { getOption().confirm(true);
		 * return true; } else { System.exit(1); } } else { } return false;
		 */
	}

	/**
	 * Für das Speichern in der Registry oder den Preferences nötige Felder
	 * 
	 * @return gibt {@link option} als StringConfigOption zurück.
	 * 
	 * @see eu.gronos.kostenrechner.interfaces.Noergelnd#getOption()
	 */
	@Override
	public LizenzConfigOption getOption() {
		return option;
	}

}
