/**
 * MacToolkiste.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import javax.swing.ImageIcon;

import com.apple.eawt.Application;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * In diese Klasse mussten die Besonderheiten für Mac OS X, damit die
 * Hauptklasse auch unter Windows ausgeführt werden kann.
 * 
 * @author Peter Schuster (setrok)
 * @date 18.07.2014
 * 
 */
public class MacDockIcon {

	/**
	 * Die Methoden der Klasse sind statisch, der Konstruktor daher private
	 * 
	 */
	private MacDockIcon() {
		// nichts zu tun
	}

	/**
	 * Die Methode dient dazu, das Dock-Icon setzen
	 * 
	 */
	public static void dockIconSetzen() {
		try {
			Application.getApplication().setDockIconImage(
					new ImageIcon(Kostenrechner.class.getClassLoader().getResource("resources/rechnerhammer-128.png"))
							.getImage());
		} catch (NoClassDefFoundError e) {
			// TODO Auto-generated catch block
			System.err.println("Nix can open Apple");
		}
	}
}
