/**
 * MacHandler.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;

import eu.gronos.kostenrechner.controller.KostenrechnerBeender;
import eu.gronos.kostenrechner.view.menus.DateiJMenu;

import com.apple.eawt.AppEvent.QuitEvent;
import com.apple.eawt.Application;

/**
 * @url "http://www.javabeginners.de/Mac-Besonderheiten/MacOSX-Menuleiste.php"
 * 
 */
public class MacQuitHandler implements QuitHandler {

	static final MacQuitHandler MAC_QUIT_HANDLER = new MacQuitHandler();

	/**
	 * Die Methode ruft {@link KostenrechnerBeender#beendeKostenrechner()} als
	 * Reaktion auf Apfel+Q auf.
	 * 
	 * @param qe ein QuitEvent
	 * @param qr eine QuitResponse
	 * 
	 * @see com.apple.eawt.QuitHandler#handleQuitRequestWith(com.apple.eawt.AppEvent.QuitEvent,
	 *      com.apple.eawt.QuitResponse)
	 */
	@Override
	public void handleQuitRequestWith(QuitEvent qe, QuitResponse qr) {
		// KostenrechnerBeender
		((KostenrechnerBeender) DateiJMenu.getInstance().getBeendenAction())//
				.beendeKostenrechner();
	}

	public static void quitSetzen() {
		try {
			Application.getApplication().setQuitHandler(MacQuitHandler.MAC_QUIT_HANDLER);
		} catch (NoClassDefFoundError e) {
			System.err.println("Nix can open Apple");
		}
	}

}