package eu.gronos.kostenrechner.controller.system;

import java.util.prefs.Preferences;

import eu.gronos.kostenrechner.Kostenrechner;

/**
 * Die Oberklasse für den Zugriff auf Registry oder Benutzereinstellungen
 * speichert den Ast /eu/gronos/kostentenor und den Schlüssel
 *
 * @author Peter Schuster (setrok)
 * @date 18 Feb 2019
 *
 */
public class PreferencesConfigOption {

	private static final Preferences userPrefs = Preferences.userRoot().node("/eu/gronos/kostentenor");
	private final String schluessel;

	/**
	 * Der Konstruktor erfordert den Wert für den finalen {@link String}
	 * {@link #getSchluessel()}
	 * 
	 * @param schluessel der Schlüssel im Unterast
	 *                   <code>"/eu/gronos/kostentenor"</code> (String)
	 */
	public PreferencesConfigOption(String schluessel) {
		this.schluessel = schluessel;
	}

	/**
	 * Die Klasse Preferences hat große Ähnlichkeit mit den Klassen Properties
	 * beziehungsweise HashMap (vergleiche Kapitel 13, »Einführung in
	 * Datenstrukturen und Algorithmen«). Schlüssel/Werte-Paare lassen sich
	 * einfügen, löschen und erfragen. Allerdings ist die Klasse Preferences kein
	 * Mitglied der Collection-API, und es existiert auch keine Implementierung von
	 * Collection-Schnittstellen.
	 * 
	 * @return gibt {@link #userprefs} als Preferences zurück.
	 */
	public Preferences getUserprefs() {
		return userPrefs;
	}

	/**
	 * @return gibt {@link #schluessel} als String zurück.
	 */
	public String getSchluessel() {
		return schluessel;
	}

	/**
	 * Die Methode loggt einen Schreibvorgang
	 * 
	 * @param wert der in die Registry/Preferences geschriebene Wert
	 */
	protected void logInfo(String wert) {
		String msg = String.format("Schreibe in Registry ... %s/%s: %s", getUserprefs().absolutePath(), getSchluessel(),
				wert);
		Kostenrechner.getLogger().info(msg);
	}
}