/**
 * SchreibeEmailAllgemein.java
 * eu.gronos.kostenrechner.view (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.model.DatenschutzZustimmung;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;

/**
 * Die {@link Action} lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client
 * über {@link TenorUtils.emailSchreiben(String, String)} schreiben.
 * {@link KeyEvent.VK_E}
 * 
 * @author Peter Schuster (setrok)
 * @date 11 Nov 2018
 *
 */
public class SchreibeEmailAllgemein extends SchreibeEmail {
	private static final long serialVersionUID = 618282849118692220L;

	/**
	 * Konstruktor.
	 * 
	 * @param beschriftung eine {@link LangBeschriftung}
	 * 
	 */
	public SchreibeEmailAllgemein(LangBeschriftung beschriftung) {
		super(beschriftung);
	}
//* @param mnemonic         {@link Action#MNEMONIC_KEY}, int mnemonic, mnemonic
//	/**
//	 * Konstruktor:  (kommentieren)
//	 * @param name             {@link Action#NAME}
//	 * @param shortDescription {@link Action#SHORT_DESCRIPTION}
//	 * @param actionCommandKey {@link Action#ACTION_COMMAND_KEY}
//	 */
//	public SchreibeEmailAllgemein(String name, String shortDescription, int mnemonic, String actionCommandKey) {
//		super(name, shortDescription, mnemonic, actionCommandKey);
//	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final String subject = "Kommentar zu kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		final String body = "Mein Kommentar zu Schusters kleinem Kostentenor:\n\n";
		if (setNoergler(
				new DatenschutzNoergler(Kostenrechner.getInstance(), DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS))
						.noergle()) {
			super.schreibe(subject, body);
			setNoergler(null);
		}
	}
}