/*

 * SchreibeEmailFehler.java
 * eu.gronos.kostenrechner.view.helpanderror (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;

/**
 * Die Klasse lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client über
 * {@link TenorUtils.emailSchreiben(String, String)} schreiben. Dabei wird der
 * Text des Tenors und noch XML-Daten mitgeschickt.
 *
 * @author Peter Schuster (setrok)
 * @date 24 Apr 2019
 *
 */
public class SchreibeEmailFehler extends SchreibeEmail {
	private static final long serialVersionUID = -4095891796997774737L;
	private final FehlerHelper feHelper;

	/**
	 * 
	 * @param throwable ein {@link Throwable}, um die {@link StackTraceElement}s
	 *                  auszulesen
	 */
	public SchreibeEmailFehler(LangBeschriftung beschriftung, FehlerHelper feHelper) {
		super(beschriftung);
		this.feHelper = feHelper;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		// Im E-Mail-Text wird der Stacktrace mitgeschickt.
		final String subject = "Fehlermeldung aus kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		final String fehler = feHelper.baueFehlerXmlString(false).toString();
		// Wenn dem Anhang nicht zugestimmt wird, einfache E-Mail schreiben. Bei
		// Zustimmung auch Fehlertext und StackTrace mitschicken
		schreibeDifferenziert(subject,
				"Bitte beschreiben Sie, wie es zu dem Fehler gekommen ist: " + SchreibeEmail.NEUER_ABSATZ,
				"Debug-Informationen für den Programmierer" + SchreibeEmail.NEUER_ABSATZ + fehler);
	}
}
// this.throwable = throwable;
// , Throwable throwable
// private final Throwable throwable;
// * @param mnemonic {@link Action#MNEMONIC_KEY}, int mnemonic, mnemonic
//(String name, String shortDescription, int mnemonic, String actionCommandKey, Throwable throwable) { super(name, shortDescription, mnemonic, actionCommandKey); }
// * @param name             {@link Action#NAME}
// * @param shortDescription {@link Action#SHORT_DESCRIPTION}
// * @param actionCommandKey {@link Action#ACTION_COMMAND_KEY}
// if (new DatenschutzNoergler(Kostenrechner.getInstance(),
// DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS)
// .noergle()) {
// if (new DatenschutzNoergler(Kostenrechner.getInstance(),
// DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG)
// .noergle()) {
// new FehlerHelper(throwable, meldung)