/**
 * EmailTenorFalschAction.java
 * eu.gronos.kostenrechner.view.result (Kostenrechner)
 */
package eu.gronos.kostenrechner.controller.system;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import eu.gronos.kostenrechner.Kostenrechner;
import eu.gronos.kostenrechner.controller.files.TenorXmlDatei;
import eu.gronos.kostenrechner.model.beschriftungen.LangBeschriftung;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;

/**
 * Die {@link Action} lässt eine Beschwerde-E-Mail im Standard-E-Mail-Client
 * über {@link TenorUtils.emailSchreiben(String, String)} schreiben. Dabei wird
 * der Text des Tenors und noch XML-Daten mitgeschickt.
 * 
 *
 *
 * @author Peter Schuster (setrok)
 * @date 22 Nov 2018
 *
 */
public class SchreibeEmailTenorFalsch extends SchreibeEmail {
	private static final long serialVersionUID = -978875818285786710L;
	private final TenorDatenContainer container;

	/**
	 * Konstruktor.
	 * 
	 * @param container ein {@link TenorDatenContainer}
	 */
	public SchreibeEmailTenorFalsch(LangBeschriftung beschriftung, TenorDatenContainer container) {
		super(beschriftung);
		this.container = container;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		final String subject = "Falscher Tenor in kostentenor.de " + Kostenrechner.KOSTENRECHNER_VERSION;
		// Im E-Mail-Text werden Tenor und noch XML-Daten mitgeschickt
		final String xmlString = new TenorXmlDatei().toXmlString(container);
		final String tenor = container.hauptsacheEntscheidung.text + container.kostenEntscheidung.text
				+ container.vollstreckbarkeitsEntscheidung.text + container.sonstigeEntscheidung.text;
		// Wenn dem Anhang nicht zugestimmt wird, einfache E-Mail schreiben. Bei
		// Zustimmung auch TenorDaten-XML mitschicken
		schreibeDifferenziert(subject,
				"Aus den folgenden Gründen halte ich den Tenor für falsch: " + SchreibeEmail.NEUER_ABSATZ,
				SchreibeEmail.NEUER_ABSATZ + tenor + SchreibeEmail.NEUER_ABSATZ + xmlString);

	}
	// if (new DatenschutzNoergler(Kostenrechner.getInstance(),
	// DatenschutzZustimmung.OPTION_DSGVO_EMAIL_BASIS)
	// .noergle()) {
	// if (new DatenschutzNoergler(Kostenrechner.getInstance(),
	// DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG)
	// .noergle()) {
	// DatenschutzNoergler noergler = new
	// DatenschutzNoergler(Kostenrechner.getInstance(),
	// DatenschutzZustimmung.OPTION_DSGVO_EMAIL_ANHANG);
	// noergler.noergle();
	// DatenschutzZustimmung zustimmung = noergler.getZustimmung();
	// if (zustimmung.emailBasisZugestimmt) {
	// //final StringBuilder body = new StringBuilder("Aus den folgenden Gründen
	// halte ich den Tenor für falsch\n:");
	// if (zustimmung.emailAnhangZugestimmt) {
	// // //body.append(SchreibeEmail.NEUER_ABSATZ + tenor +
	// SchreibeEmail.NEUER_ABSATZ + xmlString);
	// }
	// super.schreibe(subject, body.toString());
	// }
}
//	 * @param mnemonic  {@link Action#MNEMONIC_KEY}
// * @param tenorDatenContainer ein {@link VerfahrensDatenContainer}
// tenorDatenContainer; private final VerfahrensDatenContainer
// tenorDatenContainer, VerfahrensDatenContainer, mnemonic, int mnemonic
// this.tenorDatenContainer = tenorDatenContainer;
//	 * @param name                {@link Action#NAME}
//	 * @param shortDescription    {@link Action#SHORT_DESCRIPTION}
//	 * @param actionCommandKey    {@link Action#ACTION_COMMAND_KEY}
//	(String name, String shortDescription, int mnemonic, String actionCommandKey) { super(name, shortDescription, mnemonic, actionCommandKey); }
// final String xmlString = new BerechnungXmlDatei().toXmlString(container);
// final String tenor = new TenorXmlDatei().toXmlString(tenorDatenContainer);
// (ich bin mir bewusst und damit einverstanden, dass in der E-Mail mein Name
// und meine E-Mail-Adresse übermittelt werden sowie die anliegenden
// Programmdaten)