/*
 * Bebildert.java
 * eu.gronos.kostenrechner.model.beschriftungen (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import java.net.URL;

import eu.gronos.kostenrechner.model.beschriftungen.NameContainer;

/**
 * Interface für {@link NameContainer}s mit {@link #getImage()}
 *
 * @author Peter Schuster (setrok)
 * @date 02.02.2020
 *
 */
public interface Bebildert {

	/**
	 * The key used for storing an <code>Icon</code>. This is typically used by
	 * buttons, such as <code>JButton</code> and <code>JToggleButton</code>.
	 * 
	 * @return gibt {@link #image} als {@link String} zurück, denn {@link URL} geht
	 *         nicht.
	 */
	public String getImage();

	/**
	 * @param img d. {@link #image}, d. gesetzt werden soll als {@link URL}.
	 */
	public void setImage(String img);

}