/**
 * Tenorierend.java
 * eu.gronos.kostenrechner (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

/**
 * Das Interface schreibt Klassen vor, auch Gründe zu liefern. Dadurch zeichnet
 * es Klassen aus, die zur Tenorfindung bei Urteilen gebaut sind und so z.B. in
 * eine GUI eingebaut werden können.
 * 
 * @author Peter Schuster (setrok)
 * @date 15.05.2014
 * 
 */
public interface Begruendend {
	/**
	 * Die Methode soll eine Begründung für den Tenor zurückgeben, vor allem für den
	 * Kostentenor.
	 * 
	 * @return den Text Gründe/Entscheidungsgründe als String
	 */
	abstract String getGruende();

}
