/*
 * DialogLieferant.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JDialog;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.view.HinzufuegenDialog;
import eu.gronos.kostenrechner.view.KostenJDialog;

/**
 * Von {@link AbfrageLieferant} abgeleitetes Interface für
 * {@link BeschriebeneAktion}en, die einen {@link HinzufuegenDialog} (nicht nur
 * einen {@link JDialog}) aufrufen.
 *
 * @author Peter Schuster (setrok)
 * @date 29.10.2019
 *
 */
public interface DialogLieferant extends AbfrageLieferant {

	/**
	 * @return gibt den {@link HinzufuegenDialog} zurück, den die
	 *         {@link BeschriebeneAktion} erstellt.
	 */
	public /*HinzufuegenDialog<?>*/ KostenJDialog getDialog();
}
