/*
 * GebuehrenTableTextfieldHandler.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JFormattedTextField;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.view.gebuehren.GebuehrenBerechnungPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Das Interface hilft einer {@link BeschriebeneAktion}, sich mit dem
 * {@link TeilklageruecknahmePanel} oder {@link GebuehrenBerechnungPanel} über
 * {@link JFormattedTextField}s und {@link GebuehrenTableModel}s
 * auszutauschen.
 *
 * @author Peter Schuster (setrok)
 * @date 27 Apr 2019
 *
 */
public interface GebuehrenTableTextfieldHandler
		extends PanelTableModelHandler<GebuehrenTableModel>, PanelTextFieldHandler {

	/*
	 * Die Methode dient dazu, dass eine {@link BeschriebeneAktion} den Focus auf
	 * die {@link JComponent} legen kann, die sie aufruft.
	 * 
	 * @return <code>true</code>, wenn der Aufruf wahrscheinlich Erfolg hat;
	 * <code>false</code>, wenn er zum Scheitern verurteilt ist.
	 * 
	 * @see javax.swing.JComponent#requestFocusInWindow() public boolean
	 * requestFocusInWindow();
	 * 
	 */
}
