/*
 * Listener2MenuItem.java
 * eu.gronos.kostenrechner.controller (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import java.awt.event.ItemListener;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.beschriftungen.NameContainer;
import eu.gronos.kostenrechner.view.menus.PopupMenuBuilder;

/**
 * Interface für {@link Action}s und {@link ItemListener}s, das die Methoden
 * {@link #toMenuItem()} und {@link #toMenuItem(JMenuItem)} bereitstellt. Dient
 * als Teil-Parameter-Objekt für {@link PopupMenuBuilder}
 *
 * @author Peter Schuster (setrok)
 * @date 30.01.2020
 *
 */
public interface HorcherWandelbar {

	/**
	 * Die Methode baut ein {@link JMenuItem} mit der {@link BeschriebeneAktion}
	 * bzw. dem {@link ItemListener} und setzt zusätzlich
	 * {@link JMenuItem#getName()} auf die {@link NameContainer#getId()}.
	 * 
	 * @return das erstellte {@link JMenuItem}
	 */
	public JMenuItem toMenuItem();

	/**
	 * Die Methode versieht ein {@link JMenuItem} oder ein abgeleitetes Objekt mit
	 * der {@link BeschriebeneAktion} oder dem {@link ItemListener} und setzt
	 * zusätzlich {@link JMenuItem#getName()} auf die {@link NameContainer#getId()}.
	 * 
	 * @param item ein {@link JMenuItem}
	 * @return das präparierte {@link JMenuItem}
	 */
	public JMenuItem toMenuItem(JMenuItem item);

	/**
	 * Die Methode baut einen {@link AbstractButton} oder ein abgeleitetes Objekt
	 * mit der {@link BeschriebeneAktion} oder dem {@link ItemListener} und setzt
	 * zusätzlich {@link AbstractButton#getName()} auf die
	 * {@link NameContainer#getId()}.
	 * 
	 * @return den erstellten {@link AbstractButton}
	 */
	public AbstractButton toButton();

	/**
	 * Die Methode versieht einen {@link AbstractButton} oder ein abgeleitetes
	 * Objekt mit der {@link BeschriebeneAktion} oder dem {@link ItemListener} und
	 * setzt zusätzlich {@link AbstractButton#getName()} auf die
	 * {@link NameContainer#getId()}.
	 * 
	 * @param button einen {@link AbstractButton}
	 * @return den präparierten {@link AbstractButton}
	 */
	public AbstractButton toButton(AbstractButton button);

}