/*
 * Noergelnd.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.controller.system.PreferencesConfigOption;

/**
 * Ein Interface für Klassen, die prüfen, ob die <code>option</code> noch nicht
 * akzeptiert wurde, dann nörgeln. Wenn nicht akzeptiert wird, dann Programm
 * beenden. Sonst Vermerk in Registry/Preferences und weiter.
 *
 * @author Peter Schuster (setrok)
 * @date 22 Apr 2019
 *
 */
public interface Noergelnd<E extends PreferencesConfigOption> {

	/**
	 * Die Methode soll prüfen, ob die <code>option</code> noch nicht akzeptiert
	 * wurde, dann nörgeln. Wenn nicht akzeptiert wird, dann Programm beenden. Sonst
	 * Vermerk in Registry/Preferences und weiter.
	 */
	public boolean noergle();

	/**
	 * Die Methode gibt die {@link PreferencesConfigOption} zurück, die passt.
	 * 
	 * @return die {@link PreferencesConfigOption} zu dem index
	 */
	public E getOption();
}
