/*
 * TableModelGebend.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

import eu.gronos.kostenrechner.controller.BeschriebeneAktion;
import eu.gronos.kostenrechner.model.gebuehren.GebuehrenTableModel;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;
import eu.gronos.kostenrechner.view.KostenJPanel;
import eu.gronos.kostenrechner.view.gebuehren.TeilklageruecknahmePanel;

/**
 * Das Interface hilft einer {@link BeschriebeneAktion}, mit dem
 * {@link KostenJPanel} kommunizieren zu können.
 *
 * @author Peter Schuster (setrok)
 * @date 13 Apr 2019
 *
 */
public interface PanelTableModelHandler<T extends AbstractTableModel> {

	/**
	 * Die Methode dient dazu das passende {@link GebuehrenTableModel}
	 * zurück zu geben.
	 * 
	 * @param index ein Bezeichner für das {@link TableModel}, etwa
	 *              {@link TeilklageruecknahmePanel#TAB_VORHER} oder
	 *              {@link TeilklageruecknahmePanel#TAB_NACHHER} bzw.
	 *              {@link Beteiligter#KLAEGER}, {@link Beteiligter#BEKLAGTE} oder
	 *              {@link Beteiligter#DRITTWIDERBEKLAGTE}
	 * @return
	 */
	T getTableModel(int index);

	/**
	 * Die Methode muss prüfen, ob die Tabellen Werte enthalten.
	 * 
	 * @return true, wenn die Tabelle ausreichend Werte enthalten; false, wenn auch
	 *         nur eine der beiden leer ist.
	 */
	boolean pruefeTabellen();
	
	/**
	 * Die Methode dient dazu, dass eine {@link BeschriebeneAktion} den Focus auf
	 * die {@link JComponent} legen kann, die sie aufruft.
	 * 
	 * @return <code>true</code>, wenn der Aufruf wahrscheinlich Erfolg hat;
	 *         <code>false</code>, wenn er zum Scheitern verurteilt ist.
	 * 
	 * @see javax.swing.JComponent#requestFocusInWindow()
	 */
	public boolean requestFocusInWindow();
}