/*
 * ContainerWerteSetzend.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.AbstractAction;
import javax.swing.JFrame;

import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldBkExtractAction;
import eu.gronos.kostenrechner.controller.baumbach.StreitgenossenGesamtschuldDwbkExtractAction;
import eu.gronos.kostenrechner.model.baumbach.BeteiligtenTableModel;
import eu.gronos.kostenrechner.model.baumbach.Streitgenossen;
import eu.gronos.kostenrechner.model.tenordaten.Beteiligter;

/**
 * Das Interface markiert eine Klasse, die anhand eines
 * {@link UnterContainerKlasse}
 * {@link eu.gronos.kostenrechner.model.baumbach.Streitgenossen}
 * die Werte ihres Panels mit den im Container enthalten Werten setzt.
 *
 * @author Peter Schuster (setrok)
 * @date 12 Apr 2019
 *
 */
public interface StreitgenossenTabellenBehandelnd extends PanelTableModelHandler<BeteiligtenTableModel> {

	/**
	 * Die Methode leert die Baumbach-Tabellen und füllt sie mit den Daten aus dem
	 * Untercontainer
	 * {@link eu.gronos.kostenrechner.model.baumbach.Streitgenossen}
	 * 
	 * @param container ein Untercontainer
	 *                  {@link eu.gronos.kostenrechner.model.baumbach.Streitgenossen}
	 * @see eu.gronos.kostenrechner.view.KostenJPanel#setzeWerte(Streitgenossen, java.lang.Object)
	 */
	public void setzeWerte(Streitgenossen container);

	/**
	 * Die Methode muss prüfen, ob die Tabellen Werte enthalten.
	 * 
	 * @return true, wenn die Tabelle ausreichend Werte enthalten; false, wenn auch
	 *         nur eine der beiden leer ist.
	 */
	boolean pruefeTabellen();

	/**
	 * Die Methode dient gibt zurück, ob Werte für eine Widerklage gerade angezeigt
	 * werden
	 * 
	 * @return true, wenn die Widerklage gerade angezeigt wird
	 */
	public boolean isWiderKlageAnzeigen();

	/**
	 * Die Methode setWiderklageAnzeigen dient zum Aktivieren der Widerklagen. Bei
	 * allen TableModels widerKlageAnzeigen setzen, Dwbk-Tabelle und Schaltflächen
	 * wieder auf Visible setzen, eigene Schaltflächen ausblenden.
	 * 
	 * @param widerKlageAnzeigen der Wert für widerKlageAnzeigen, der gesetzt werden
	 *                           soll.
	 */
	public void setWiderKlageAnzeigen(boolean widerKlageAnzeigen);

	/**
	 * @return gibt {@link #wirtschaftlichIdentisch} als boolean zurück.
	 */
	public boolean isWirtschaftlichIdentisch();

	/**
	 * @param wirtschaftlichIdentisch d. {@link #wirtschaftlichIdentisch}, d.
	 *                                gesetzt werden soll als boolean
	 */
	public void setWirtschaftlichIdentisch(boolean wirtschaftlichIdentisch);

	/**
	 * Die Methode gibt den übergeordneten {@link JFrame} zurück
	 * 
	 * @return einen {@link JFrame}
	 */
	JFrame getKostenrechner();

	/**
	 * Die Methode liefert die {@link AbstractAction} zum Extrahieren von
	 * Gesamtschuldnern.
	 * 
	 * @param beteiligtenTyp {@link Beteiligter#BEKLAGTE} oder
	 *                       {@link Beteiligter#DRITTWIDERBEKLAGTE}
	 * @return {@link StreitgenossenGesamtschuldBkExtractAction} bzw.
	 *         {@link StreitgenossenGesamtschuldDwbkExtractAction}
	 * @throws IllegalArgumentException wenn beteiligtenTyp keines der beiden
	 *                                  angegebenen ist.
	 */
	public AbstractAction getExtrahierenAktion(int beteiligtenTyp) throws IllegalArgumentException;
}