/*
 * TableModelGebend.java
 * eu.gronos.kostenrechner.view.baumbach (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/**
 * Das Interface markiert Klassen (v.a. {@link JPanel}s), die ein
 * {@link TableModel} zurückgeben können.
 *
 * @author Peter Schuster (setrok)
 * @date 12 Apr 2019
 *
 */
public interface TableModelGebend<E extends AbstractTableModel> {

	/**
	 * Die Methode gibt ein {@link TableModel} nach dem übergebenen index zurück.
	 * Die Nummerierung der Indexes kann je nach Implementierung anders sein.
	 * 
	 * @param index der Index des {@link TableModel}s in dem {@link JPanel}
	 * @return das ausgewählte {@link TableModel}
	 */
	E getTableModel(int index);

}