/**
 * TenorVorbereitend.java
 * eu.gronos.kostenrechner.interfaces (Kostenrechner)
 */
package eu.gronos.kostenrechner.interfaces;

import eu.gronos.kostenrechner.model.tenordaten.BegruendungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.HauptsacheEntscheidungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.KostenGrundEntscheidungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.SonstigeEntscheidungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.StreitwertEntscheidungsElemente;
import eu.gronos.kostenrechner.model.tenordaten.TenorDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VerfahrensDatenContainer;
import eu.gronos.kostenrechner.model.tenordaten.VollstreckbarkeitsEntscheidungsElemente;

/**
 * Das Interface schreibt Klassen vor, Methoden zu Einzeltenoren zu
 * implementieren. So kann ein Adapter daraus den String zu der Methode String
 * erzeugeTenor() bauen.
 * 
 * Eine implementierende Klasse sollte so funktionieren, dass sie einen
 * {@link VerfahrensDatenContainer} bzw. einen {@link UnterContainerKlasse}
 * daraus als Parameter bekommt und einen {@link TenorDatenContainer} erzeugt.
 * 
 * @author Peter Schuster (setrok)
 * @date 18.10.2018
 *
 */
public interface TenorVorbereitend {
	/**
	 * Die Methode soll einen Hauptsachetenor erzeugen.
	 * 
	 * @return ein komplettes {@link HauptsacheEntscheidungsElemente}-Objekt, darin
	 *         den Text des Hauptsachetenors als String mit abschließendem
	 *         Zeilenumbruch, 
	 */
	abstract HauptsacheEntscheidungsElemente erzeugeHauptsacheEntscheidung();

	/**
	 * Die Methode soll einen Kostentenor erzeugen.
	 * 
	 * @return ein komplettes {@link KostenGrundEntscheidungsElemente}-Objekt
	 *         zurückgeben, also vor allem den Text des Kostentenors als String mit
	 *         abschließendem Zeilenumbruch.
	 */
	abstract KostenGrundEntscheidungsElemente erzeugeKostenEntscheidung();

	/**
	 * Die Methode erzeugt den Tenor zur vorläufigen Vollstreckbarkeit
	 * 
	 * @return ein komplettes {@link VollstreckbarkeitsEntscheidungsElemente}, vor
	 *         allem einen String mit dem Tenortext mit abschließendem
	 *         Zeilenumbruch.
	 */
	abstract VollstreckbarkeitsEntscheidungsElemente erzeugeVollstreckbarkeitsEntscheidung();

	/**
	 * Die Methode soll eine Streitwertfestsetzung erzeugen.
	 * 
	 * @return ein komplettes {@link StreitwertEntscheidungsElemente}, darin v.a.
	 *         den Text der Streitwertfestsetzung als String mit abschließendem
	 *         Zeilenumbruch.
	 */
	abstract StreitwertEntscheidungsElemente erzeugeStreitwertEntscheidung();

	/**
	 * Die Methode soll den Container für eine sonstige Entscheidung (etwa die
	 * Gebührenaufstellung) erzeugen. Er darf auch nur leeren Text enthalten. Wenn
	 * er Text enthält, dann mit einem Zeilenumbruch beendeten.
	 * 
	 * @return einen Untercontainer vom Typ {@link SonstigeEntscheidungsElemente}
	 */
	abstract SonstigeEntscheidungsElemente erzeugeSonstigeEntscheidung();

	/**
	 * Die Methode soll einen {@link TenorDatenContainer} zusammenbauen. Der besteht
	 * aus {@link HauptsacheEntscheidungsElemente},
	 * {@link KostenGrundEntscheidungsElemente},
	 * {@link VollstreckbarkeitsEntscheidungsElemente},
	 * {@link StreitwertEntscheidungsElemente},
	 * {@link SonstigeEntscheidungsElemente} und {@link BegruendungsElemente}.
	 * 
	 * @return den erstellten Container
	 */
	abstract TenorDatenContainer erzeugeContainer();

	/**
	 * Die Methode soll eine Beschreibung für die Art des Tenors, also des Typs der
	 * Berechnung zurückgeben, damit andere Klassen etwa das Dokument danach
	 * benennen können.
	 * 
	 * @return
	 */
	abstract String getBerechnungsTyp();

}
